"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleCategorization = handleCategorization;
var _output_parsers = require("@langchain/core/output_parsers");
var _processors = require("../../util/processors");
var _constants = require("./constants");
var _prompts = require("./prompts");
var _util = require("./util");
var _constants2 = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleCategorization({
  state,
  model
}) {
  const categorizationMainPrompt = _prompts.CATEGORIZATION_MAIN_PROMPT;
  const outputParser = new _output_parsers.JsonOutputParser();
  const categorizationMainGraph = categorizationMainPrompt.pipe(model).pipe(outputParser);
  const [pipelineResults, _] = (0, _util.selectResults)(state.pipelineResults, _constants2.CATEGORIZATION_INITIAL_BATCH_SIZE, new Set(state.stableSamples));
  const currentProcessors = await categorizationMainGraph.invoke({
    pipeline_results: JSON.stringify(pipelineResults, null, 2),
    example_processors: _constants.CATEGORIZATION_EXAMPLE_PROCESSORS,
    ex_answer: state === null || state === void 0 ? void 0 : state.exAnswer,
    ecs_categories: state === null || state === void 0 ? void 0 : state.ecsCategories,
    ecs_types: state === null || state === void 0 ? void 0 : state.ecsTypes
  });
  const processors = {
    type: 'categorization',
    processors: currentProcessors
  };
  const currentPipeline = (0, _processors.combineProcessors)(state.initialPipeline, processors);
  return {
    currentPipeline,
    currentProcessors,
    lastReviewedSamples: [],
    lastExecutedChain: 'categorization'
  };
}