"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexManagementHref = getIndexManagementHref;
exports.getKibanaAdvancedSettingsHref = getKibanaAdvancedSettingsHref;
exports.getStorageExplorerFeedbackHref = getStorageExplorerFeedbackHref;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getIndexManagementHref(core, dataStream) {
  const indexManagementPath = '/data/index_management/data_streams';
  return core.application.getUrlForApp('management', {
    path: dataStream ? `${indexManagementPath}/${dataStream}?isDeepLink=true` : indexManagementPath
  });
}
function getStorageExplorerFeedbackHref() {
  return 'https://ela.st/feedback-storage-explorer';
}
function getKibanaAdvancedSettingsHref(core) {
  return core.application.getUrlForApp('management', {
    path: '/kibana/settings?query=categories:(observability)'
  });
}