"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRadioGroup = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _form_fieldset = require("../form_fieldset");
var _radio = require("./radio");
var _radio_group = require("./radio_group.styles");
var _react2 = require("@emotion/react");
var _excluded = ["options", "idSelected", "onChange", "name", "className", "disabled", "compressed", "legend"],
  _excluded2 = ["disabled", "className", "id", "label"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Must omit inherit `onChange` properties or else TS complains when applying to the EuiRadio
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiRadioGroup = exports.EuiRadioGroup = function EuiRadioGroup(_ref) {
  var _ref$options = _ref.options,
    options = _ref$options === void 0 ? [] : _ref$options,
    idSelected = _ref.idSelected,
    onChange = _ref.onChange,
    name = _ref.name,
    className = _ref.className,
    disabled = _ref.disabled,
    compressed = _ref.compressed,
    legend = _ref.legend,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiRadioGroup', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_radio_group.euiRadioGroupStyles);
  var cssStyles = [styles.euiRadioGroup, compressed ? styles.compressed : styles.uncompressed];
  var radios = options.map(function (option, index) {
    var isOptionDisabled = option.disabled,
      optionClass = option.className,
      id = option.id,
      label = option.label,
      optionRest = _objectWithoutProperties(option, _excluded2);
    return (0, _react2.jsx)(_radio.EuiRadio, _extends({
      className: (0, _classnames.default)('euiRadioGroup__item', optionClass),
      key: index,
      name: name,
      checked: id === idSelected,
      disabled: disabled || isOptionDisabled,
      onChange: onChange.bind(null, id, option.value),
      id: id,
      label: label
    }, optionRest));
  });
  if (!!legend) {
    // Be sure to pass down the compressed option to the legend
    legend.compressed = compressed;
    return (0, _react2.jsx)(_form_fieldset.EuiFormFieldset, _extends({
      css: cssStyles,
      className: classes,
      legend: legend
    }, rest), radios);
  }
  return (0, _react2.jsx)("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), radios);
};
EuiRadioGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Passed down to all child `EuiCheckbox`es
     */
  disabled: _propTypes.default.bool,
  /**
     * Tightens up the spacing between radio rows
     */
  compressed: _propTypes.default.bool,
  name: _propTypes.default.string,
  options: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired
  }).isRequired).isRequired,
  idSelected: _propTypes.default.string,
  onChange: _propTypes.default.func.isRequired,
  /**
     * If the individual labels for each radio do not provide a sufficient description, add a legend.
     * Wraps the group in a `EuiFormFieldset` which adds an `EuiLegend` for titling the whole group.
     * Accepts an `EuiFormLegendProps` shape.
     */
  legend: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    /**
         * ReactNode to render as this component's content
         */
    children: _propTypes.default.node.isRequired,
    /**
         * For a hidden legend that is still visible to the screen reader, set to 'hidden'
         */
    display: _propTypes.default.oneOf(["hidden", "visible"]),
    compressed: _propTypes.default.bool
  })
};