"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKnowledgeBaseEntryRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _utils = require("../../utils");
var _helpers = require("../../helpers");
var _transforms = require("../../../ai_assistant_data_clients/knowledge_base/transforms");
var _utils2 = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKnowledgeBaseEntryRoute = router => {
  router.versioned.get({
    access: 'public',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BY_ID,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    validate: {
      request: {
        params: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.ReadKnowledgeBaseEntryRequestParams)
      }
    }
  }, async (context, request, response) => {
    const assistantResponse = (0, _utils.buildResponse)(response);
    try {
      var _result$data;
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);

      // Perform license, authenticated user and FF checks
      const checkResponse = await (0, _helpers.performChecks)({
        context: ctx,
        request,
        response
      });
      if (!checkResponse.isSuccess) {
        return checkResponse.response;
      }
      const kbDataClient = await ctx.elasticAssistant.getAIAssistantKnowledgeBaseDataClient();
      const currentUser = checkResponse.currentUser;
      const userFilter = (0, _utils2.getKBUserFilter)(currentUser);
      const systemFilter = ` AND _id: "${request.params.id}"`;
      const result = await (kbDataClient === null || kbDataClient === void 0 ? void 0 : kbDataClient.findDocuments({
        perPage: 1,
        page: 1,
        sortField: 'created_at',
        sortOrder: 'desc',
        filter: `${userFilter}${systemFilter}`,
        fields: ['*']
      }));
      if (!(result !== null && result !== void 0 && (_result$data = result.data) !== null && _result$data !== void 0 && _result$data.hits.hits.length)) {
        return response.notFound();
      }
      return response.ok({
        body: (0, _transforms.transformESSearchToKnowledgeBaseEntry)(result.data)[0]
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getKnowledgeBaseEntryRoute = getKnowledgeBaseEntryRoute;