"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateVolatileSearchSource = updateVolatileSearchSource;
var _public = require("@kbn/data-views-plugin/public");
var _discoverUtils = require("@kbn/discover-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Helper function to update the given searchSource before fetching/sharing/persisting
 */
function updateVolatileSearchSource(searchSource, {
  dataView,
  services,
  sort,
  inputTimeRange
}) {
  const {
    uiSettings,
    data
  } = services;
  const usedSort = (0, _discoverUtils.getSortForSearchSource)({
    sort,
    dataView,
    defaultSortDir: uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING),
    includeTieBreaker: true
  });
  searchSource.setField('sort', usedSort);
  searchSource.setField('trackTotalHits', true);
  if (dataView.type !== _public.DataViewType.ROLLUP) {
    // Set the date range filter fields from timeFilter using the absolute format. Search sessions requires that it be converted from a relative range
    searchSource.setField('filter', data.query.timefilter.timefilter.createFilter(dataView, inputTimeRange));
  }
  searchSource.removeField('fieldsFromSource');
  searchSource.setField('fields', [{
    field: '*',
    include_unmapped: true
  }]);
}