"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldsWithSubFields = void 0;
var _mlIsDefined = require("@kbn/ml-is-defined");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Helper logic to add multi-fields to the table for embeddables outside of Index data visualizer
 * For example, adding {field} will also add {field.keyword} if it exists
 * @param indexPatternTitle
 * @returns
 */
const getFieldsWithSubFields = ({
  input,
  currentDataView,
  shouldGetSubfields = false
}) => {
  var _input$fieldsToFetch;
  const dataViewFields = currentDataView.fields;
  const visibleFieldsWithSubFields = shouldGetSubfields ? [...new Set([...dataViewFields.filter(field => {
    var _input$visibleFieldNa, _input$visibleFieldNa2;
    if ((input === null || input === void 0 ? void 0 : (_input$visibleFieldNa = input.visibleFieldNames) === null || _input$visibleFieldNa === void 0 ? void 0 : _input$visibleFieldNa.length) === 0) return true;
    const visibleNames = (_input$visibleFieldNa2 = input === null || input === void 0 ? void 0 : input.visibleFieldNames) !== null && _input$visibleFieldNa2 !== void 0 ? _input$visibleFieldNa2 : [];
    if (visibleNames.includes(field.name)) return true;
    if (field.getSubtypeMulti) {
      var _field$getSubtypeMult, _field$getSubtypeMult2;
      const parent = (_field$getSubtypeMult = field.getSubtypeMulti()) === null || _field$getSubtypeMult === void 0 ? void 0 : (_field$getSubtypeMult2 = _field$getSubtypeMult.multi) === null || _field$getSubtypeMult2 === void 0 ? void 0 : _field$getSubtypeMult2.parent;
      const matchesParent = parent ? visibleNames.indexOf(parent) > -1 : false;
      if (matchesParent) {
        return true;
      }
    }
    return false;
  }).map(f => f.name), ...((_input$fieldsToFetch = input.fieldsToFetch) !== null && _input$fieldsToFetch !== void 0 ? _input$fieldsToFetch : []),,])].filter(_mlIsDefined.isDefined) : undefined;
  return {
    visibleFieldNames: shouldGetSubfields ? visibleFieldsWithSubFields : input.visibleFieldNames,
    fieldsToFetch: Array.isArray(visibleFieldsWithSubFields) ? [...visibleFieldsWithSubFields] : undefined
  };
};
exports.getFieldsWithSubFields = getFieldsWithSubFields;