"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataQualityPlugin = void 0;
var _constants = require("@kbn/deeplinks-management/constants");
var _features = require("./features");
var _locators = require("../common/locators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataQualityPlugin {
  setup(_coreSetup, {
    features,
    share
  }) {
    features.registerKibanaFeature(_features.KIBANA_FEATURE);
    features.registerElasticsearchFeature(_features.ELASTICSEARCH_FEATURE);
    const managementLocator = share.url.locators.get(_constants.MANAGEMENT_APP_LOCATOR);
    if (managementLocator) {
      share.url.locators.create(new _locators.DatasetQualityLocatorDefinition({
        useHash: false,
        managementLocator
      }));
      share.url.locators.create(new _locators.DatasetQualityDetailsLocatorDefinition({
        useHash: false,
        managementLocator
      }));
    }
  }
  start() {}
  stop() {}
}
exports.DataQualityPlugin = DataQualityPlugin;