"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateIndexMappingsWaitForTask = void 0;
require("lodash");
var Either = _interopRequireWildcard(require("fp-ts/Either"));
var _retry_state = require("../../../model/retry_state");
var _helpers = require("../../../model/helpers");
var _actions = require("../../actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const updateIndexMappingsWaitForTask = (state, res, context) => {
  if (Either.isLeft(res)) {
    const left = res.left;
    if ((0, _actions.isTypeof)(left, 'wait_for_task_completion_timeout')) {
      // After waiting for the specified timeout, the task has not yet
      // completed. Retry this step to see if the task has completed after an
      // exponential delay.  We will basically keep polling forever until the
      // Elasticsearch task succeeds or fails.
      return (0, _retry_state.delayRetryState)(state, left.message, Number.MAX_SAFE_INTEGER);
    } else if ((0, _actions.isTypeof)(left, 'task_completed_with_retriable_error')) {
      return (0, _retry_state.delayRetryState)({
        ...state,
        controlState: 'UPDATE_INDEX_MAPPINGS',
        skipRetryReset: true
      }, left.message, context.maxRetryAttempts);
    } else {
      (0, _helpers.throwBadResponse)(state, left);
    }
  }
  return {
    ...state,
    controlState: 'UPDATE_MAPPING_MODEL_VERSIONS'
  };
};
exports.updateIndexMappingsWaitForTask = updateIndexMappingsWaitForTask;