"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoreSystem = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _css = require("@emotion/css");
var _rxjs = require("rxjs");
var _coreInjectedMetadataBrowserInternal = require("@kbn/core-injected-metadata-browser-internal");
var _coreLoggingBrowserInternal = require("@kbn/core-logging-browser-internal");
var _coreDocLinksBrowserInternal = require("@kbn/core-doc-links-browser-internal");
var _coreThemeBrowserInternal = require("@kbn/core-theme-browser-internal");
var _coreAnalyticsBrowserInternal = require("@kbn/core-analytics-browser-internal");
var _coreI18nBrowserInternal = require("@kbn/core-i18n-browser-internal");
var _coreExecutionContextBrowserInternal = require("@kbn/core-execution-context-browser-internal");
var _coreFatalErrorsBrowserInternal = require("@kbn/core-fatal-errors-browser-internal");
var _coreFeatureFlagsBrowserInternal = require("@kbn/core-feature-flags-browser-internal");
var _coreHttpBrowserInternal = require("@kbn/core-http-browser-internal");
var _coreUiSettingsBrowserInternal = require("@kbn/core-ui-settings-browser-internal");
var _coreDeprecationsBrowserInternal = require("@kbn/core-deprecations-browser-internal");
var _coreIntegrationsBrowserInternal = require("@kbn/core-integrations-browser-internal");
var _ebtTools = require("@kbn/ebt-tools");
var _coreOverlaysBrowserInternal = require("@kbn/core-overlays-browser-internal");
var _coreSavedObjectsBrowserInternal = require("@kbn/core-saved-objects-browser-internal");
var _coreNotificationsBrowserInternal = require("@kbn/core-notifications-browser-internal");
var _coreChromeBrowserInternal = require("@kbn/core-chrome-browser-internal");
var _coreApplicationBrowserInternal = require("@kbn/core-application-browser-internal");
var _coreRenderingBrowserInternal = require("@kbn/core-rendering-browser-internal");
var _coreAppsBrowserInternal = require("@kbn/core-apps-browser-internal");
var _corePluginsBrowserInternal = require("@kbn/core-plugins-browser-internal");
var _corePricingBrowserInternal = require("@kbn/core-pricing-browser-internal");
var _coreCustomBrandingBrowserInternal = require("@kbn/core-custom-branding-browser-internal");
var _coreSecurityBrowserInternal = require("@kbn/core-security-browser-internal");
var _coreUserProfileBrowserInternal = require("@kbn/core-user-profile-browser-internal");
var _react = require("react");
var _reactMuteLegacyRootWarning = require("@kbn/react-mute-legacy-root-warning");
var _events = require("./events");
var _fetch_optional_memory_info = require("./fetch_optional_memory_info");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * @internal
 */

// Expands the definition of navigator to include experimental features

/**
 * The CoreSystem is the root of the new platform, and setups all parts
 * of Kibana in the UI, including the LegacyPlatform which is managed
 * by the LegacyPlatformService. As we migrate more things to the new
 * platform the CoreSystem will get many more Services.
 *
 * @internal
 */
class CoreSystem {
  constructor(params) {
    (0, _defineProperty2.default)(this, "loggingSystem", void 0);
    (0, _defineProperty2.default)(this, "analytics", void 0);
    (0, _defineProperty2.default)(this, "fatalErrors", void 0);
    (0, _defineProperty2.default)(this, "featureFlags", void 0);
    (0, _defineProperty2.default)(this, "injectedMetadata", void 0);
    (0, _defineProperty2.default)(this, "notifications", void 0);
    (0, _defineProperty2.default)(this, "http", void 0);
    (0, _defineProperty2.default)(this, "savedObjects", void 0);
    (0, _defineProperty2.default)(this, "uiSettings", void 0);
    (0, _defineProperty2.default)(this, "settings", void 0);
    (0, _defineProperty2.default)(this, "chrome", void 0);
    (0, _defineProperty2.default)(this, "i18n", void 0);
    (0, _defineProperty2.default)(this, "overlay", void 0);
    (0, _defineProperty2.default)(this, "plugins", void 0);
    (0, _defineProperty2.default)(this, "application", void 0);
    (0, _defineProperty2.default)(this, "docLinks", void 0);
    (0, _defineProperty2.default)(this, "rendering", void 0);
    (0, _defineProperty2.default)(this, "integrations", void 0);
    (0, _defineProperty2.default)(this, "coreApp", void 0);
    (0, _defineProperty2.default)(this, "deprecations", void 0);
    (0, _defineProperty2.default)(this, "theme", void 0);
    (0, _defineProperty2.default)(this, "rootDomElement", void 0);
    (0, _defineProperty2.default)(this, "coreContext", void 0);
    (0, _defineProperty2.default)(this, "executionContext", void 0);
    (0, _defineProperty2.default)(this, "customBranding", void 0);
    (0, _defineProperty2.default)(this, "security", void 0);
    (0, _defineProperty2.default)(this, "userProfile", void 0);
    (0, _defineProperty2.default)(this, "pricing", void 0);
    (0, _defineProperty2.default)(this, "fatalErrorsSetup", null);
    const {
      rootDomElement,
      browserSupportsCsp,
      injectedMetadata
    } = params;
    this.rootDomElement = rootDomElement;
    this.loggingSystem = new _coreLoggingBrowserInternal.BrowserLoggingSystem(injectedMetadata.logging);
    this.injectedMetadata = new _coreInjectedMetadataBrowserInternal.InjectedMetadataService({
      injectedMetadata
    });
    this.coreContext = {
      coreId: Symbol('core'),
      env: injectedMetadata.env,
      logger: this.loggingSystem.asLoggerFactory()
    };
    if (this.coreContext.env.mode.dev && _react.version.startsWith('18.')) {
      (0, _reactMuteLegacyRootWarning.muteLegacyRootWarning)();
      this.coreContext.logger.get('core-system').info(`Kibana is built with and running React@${_react.version}, muting legacy root warning.`);
    }
    this.i18n = new _coreI18nBrowserInternal.I18nService();
    this.analytics = new _coreAnalyticsBrowserInternal.AnalyticsService(this.coreContext);
    this.fatalErrors = new _coreFatalErrorsBrowserInternal.FatalErrorsService(rootDomElement, () => {
      // Stop Core before rendering any fatal errors into the DOM
      this.stop();
    });
    this.featureFlags = new _coreFeatureFlagsBrowserInternal.FeatureFlagsService(this.coreContext);
    this.security = new _coreSecurityBrowserInternal.SecurityService(this.coreContext);
    this.userProfile = new _coreUserProfileBrowserInternal.UserProfileService(this.coreContext);
    this.theme = new _coreThemeBrowserInternal.ThemeService();
    this.notifications = new _coreNotificationsBrowserInternal.NotificationsService();
    this.http = new _coreHttpBrowserInternal.HttpService();
    this.savedObjects = new _coreSavedObjectsBrowserInternal.SavedObjectsService();
    this.uiSettings = new _coreUiSettingsBrowserInternal.UiSettingsService();
    this.settings = new _coreUiSettingsBrowserInternal.SettingsService();
    this.overlay = new _coreOverlaysBrowserInternal.OverlayService();
    this.chrome = new _coreChromeBrowserInternal.ChromeService({
      browserSupportsCsp,
      kibanaVersion: injectedMetadata.version,
      coreContext: this.coreContext
    });
    this.docLinks = new _coreDocLinksBrowserInternal.DocLinksService(this.coreContext);
    this.rendering = new _coreRenderingBrowserInternal.RenderingService();
    this.application = new _coreApplicationBrowserInternal.ApplicationService();
    this.integrations = new _coreIntegrationsBrowserInternal.IntegrationsService();
    this.deprecations = new _coreDeprecationsBrowserInternal.DeprecationsService();
    this.executionContext = new _coreExecutionContextBrowserInternal.ExecutionContextService();
    this.plugins = new _corePluginsBrowserInternal.PluginsService(this.coreContext, injectedMetadata.uiPlugins);
    this.pricing = new _corePricingBrowserInternal.PricingService();
    this.coreApp = new _coreAppsBrowserInternal.CoreAppsService(this.coreContext);
    this.customBranding = new _coreCustomBrandingBrowserInternal.CustomBrandingService();
    performance.mark(_events.KBN_LOAD_MARKS, {
      detail: _events.LOAD_CORE_CREATED
    });
  }
  getLoadMarksInfo() {
    if (!performance) return {};
    const reportData = {};
    const marks = performance.getEntriesByName(_events.KBN_LOAD_MARKS);
    for (const mark of marks) {
      reportData[mark.detail] = mark.startTime;
    }
    return reportData;
  }
  reportKibanaLoadedEvent(analytics) {
    /**
     * @deprecated here for backwards compatibility in FullStory
     **/
    analytics.reportEvent('Loaded Kibana', {
      kibana_version: this.coreContext.env.packageInfo.version,
      protocol: window.location.protocol
    });
    const timing = this.getLoadMarksInfo();
    const navigatorExt = navigator;
    const navigatorInfo = {};
    if (navigatorExt.deviceMemory) {
      navigatorInfo.deviceMemory = String(navigatorExt.deviceMemory);
    }
    if (navigatorExt.hardwareConcurrency) {
      navigatorInfo.hardwareConcurrency = String(navigatorExt.hardwareConcurrency);
    }
    (0, _ebtTools.reportPerformanceMetricEvent)(analytics, {
      eventName: _events.KIBANA_LOADED_EVENT,
      meta: {
        kibana_version: this.coreContext.env.packageInfo.version,
        protocol: window.location.protocol,
        ...(0, _fetch_optional_memory_info.fetchOptionalMemoryInfo)(),
        // Report some hardware metrics for bucketing
        ...navigatorInfo
      },
      duration: timing[_events.LOAD_FIRST_NAV],
      key1: _events.LOAD_START,
      value1: timing[_events.LOAD_START],
      key2: _events.LOAD_BOOTSTRAP_START,
      value2: timing[_events.LOAD_BOOTSTRAP_START],
      key3: _events.LOAD_CORE_CREATED,
      value3: timing[_events.LOAD_CORE_CREATED],
      key4: _events.LOAD_SETUP_DONE,
      value4: timing[_events.LOAD_SETUP_DONE],
      key5: _events.LOAD_START_DONE,
      value5: timing[_events.LOAD_START_DONE]
    });
    performance.clearMarks(_events.KBN_LOAD_MARKS);
  }
  async setup() {
    try {
      // Setup FatalErrorsService and it's dependencies first so that we're
      // able to render any errors.
      const injectedMetadata = this.injectedMetadata.setup();
      const analytics = this.analytics.setup({
        injectedMetadata
      });
      const theme = this.theme.setup({
        injectedMetadata
      });
      this.fatalErrorsSetup = this.fatalErrors.setup({
        injectedMetadata,
        analytics,
        theme,
        i18n: this.i18n.getContext()
      });
      await this.integrations.setup();
      this.docLinks.setup();
      this.registerLoadedKibanaEventType(analytics);
      const executionContext = this.executionContext.setup({
        analytics
      });
      const http = this.http.setup({
        injectedMetadata,
        fatalErrors: this.fatalErrorsSetup,
        executionContext
      });
      const security = this.security.setup();
      const userProfile = this.userProfile.setup();
      this.chrome.setup({
        analytics
      });
      const uiSettings = this.uiSettings.setup({
        http,
        injectedMetadata
      });
      const settings = this.settings.setup({
        http,
        injectedMetadata
      });
      const notifications = this.notifications.setup({
        uiSettings,
        analytics
      });
      const customBranding = this.customBranding.setup({
        injectedMetadata
      });
      const application = this.application.setup({
        http,
        analytics
      });
      this.coreApp.setup({
        application,
        http,
        injectedMetadata,
        notifications
      });
      const featureFlags = this.featureFlags.setup({
        injectedMetadata
      });
      const core = {
        analytics,
        application,
        fatalErrors: this.fatalErrorsSetup,
        featureFlags,
        http,
        injectedMetadata,
        notifications,
        theme,
        uiSettings,
        settings,
        executionContext,
        customBranding,
        security,
        userProfile
      };

      // Services that do not expose contracts at setup
      await this.plugins.setup(core);
      performance.mark(_events.KBN_LOAD_MARKS, {
        detail: _events.LOAD_SETUP_DONE
      });
      return {
        fatalErrors: this.fatalErrorsSetup
      };
    } catch (error) {
      if (this.fatalErrorsSetup) {
        this.fatalErrorsSetup.add(error);
      } else {
        // If the FatalErrorsService has not yet been setup, log error to console
        // eslint-disable-next-line no-console
        console.log(error);
      }
    }
  }
  async start() {
    try {
      const analytics = this.analytics.start();
      const security = this.security.start();
      const userProfile = this.userProfile.start();
      const injectedMetadata = this.injectedMetadata.start();
      const uiSettings = this.uiSettings.start();
      const settings = this.settings.start();
      const docLinks = this.docLinks.start({
        injectedMetadata
      });
      const http = this.http.start();
      const savedObjects = await this.savedObjects.start({
        http
      });
      const i18n = this.i18n.start();
      const fatalErrors = this.fatalErrors.start();
      const theme = this.theme.start();
      await this.integrations.start({
        uiSettings
      });
      const coreUiTargetDomElement = document.createElement('div');
      coreUiTargetDomElement.id = 'kibana-body';
      coreUiTargetDomElement.dataset.testSubj = 'kibanaChrome';
      const notificationsTargetDomElement = document.createElement('div');
      const overlayTargetDomElement = document.createElement('div');
      const overlays = this.overlay.start({
        i18n,
        analytics,
        theme,
        uiSettings,
        userProfile,
        targetDomElement: overlayTargetDomElement
      });
      const customBranding = this.customBranding.start();
      const application = await this.application.start({
        http,
        theme,
        overlays,
        customBranding,
        analytics
      });
      const executionContext = this.executionContext.start({
        curApp$: application.currentAppId$
      });
      const rendering = this.rendering.start({
        analytics,
        executionContext,
        i18n,
        theme,
        userProfile
      });
      const notifications = this.notifications.start({
        analytics,
        overlays,
        targetDomElement: notificationsTargetDomElement,
        rendering
      });
      const chrome = await this.chrome.start({
        application,
        docLinks,
        http,
        injectedMetadata,
        notifications,
        customBranding,
        i18n,
        theme,
        userProfile,
        uiSettings
      });
      const deprecations = this.deprecations.start({
        http
      });
      this.coreApp.start({
        application,
        docLinks,
        http,
        notifications,
        uiSettings,
        analytics,
        i18n,
        theme,
        userProfile
      });
      const featureFlags = await this.featureFlags.start();
      const pricing = await this.pricing.start({
        http
      });
      const core = {
        analytics,
        application,
        chrome,
        docLinks,
        executionContext,
        featureFlags,
        http,
        theme,
        savedObjects,
        i18n,
        injectedMetadata,
        notifications,
        overlays,
        uiSettings,
        settings,
        fatalErrors,
        deprecations,
        customBranding,
        security,
        userProfile,
        rendering,
        pricing
      };
      await this.plugins.start(core);

      // ensure the rootDomElement is empty
      this.rootDomElement.textContent = '';
      this.rootDomElement.appendChild(coreUiTargetDomElement);
      this.rootDomElement.appendChild(notificationsTargetDomElement);
      this.rootDomElement.appendChild(overlayTargetDomElement);
      const coreSystemRootDomElement = (0, _css.css)`
        overflow-x: hidden;
        min-width: 100%;
        min-height: 100%;
      `;
      this.rootDomElement.classList.add(coreSystemRootDomElement);
      this.rendering.renderCore({
        chrome,
        application,
        overlays
      }, coreUiTargetDomElement);
      performance.mark(_events.KBN_LOAD_MARKS, {
        detail: _events.LOAD_START_DONE
      });

      // Wait for the first app navigation to report Kibana Loaded
      (0, _rxjs.firstValueFrom)(application.currentAppId$.pipe((0, _rxjs.filter)(Boolean))).then(() => {
        performance.mark(_events.KBN_LOAD_MARKS, {
          detail: _events.LOAD_FIRST_NAV
        });
        this.reportKibanaLoadedEvent(analytics);
      });
      return {
        application,
        executionContext
      };
    } catch (error) {
      if (this.fatalErrorsSetup) {
        this.fatalErrorsSetup.add(error);
      } else {
        // If the FatalErrorsService has not yet been setup, log error to console
        // eslint-disable-next-line no-console
        console.error(error);
      }
    }
  }
  stop() {
    this.plugins.stop();
    this.coreApp.stop();
    this.notifications.stop();
    this.http.stop();
    this.integrations.stop();
    this.uiSettings.stop();
    this.settings.stop();
    this.chrome.stop();
    this.i18n.stop();
    this.application.stop();
    this.deprecations.stop();
    this.theme.stop();
    this.analytics.stop();
    this.featureFlags.stop();
    this.security.stop();
    this.userProfile.stop();
    this.rootDomElement.textContent = '';
  }

  /**
   * @deprecated
   */
  registerLoadedKibanaEventType(analytics) {
    analytics.registerEventType({
      eventType: 'Loaded Kibana',
      schema: {
        kibana_version: {
          type: 'keyword',
          _meta: {
            description: 'The version of Kibana'
          }
        },
        protocol: {
          type: 'keyword',
          _meta: {
            description: 'Value from window.location.protocol'
          }
        }
      }
    });
  }
}
exports.CoreSystem = CoreSystem;