"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultSelectionState = void 0;
exports.initializeSelectionsManager = initializeSelectionsManager;
exports.selectionComparators = void 0;
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _state_manager = require("@kbn/presentation-publishing/state_manager");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function areSelectedOptionsEqual(a, b) {
  return (0, _reactFastCompare.default)(a !== null && a !== void 0 ? a : [], b !== null && b !== void 0 ? b : []);
}
const selectionComparators = exports.selectionComparators = {
  exclude: 'referenceEquality',
  existsSelected: 'referenceEquality',
  selectedOptions: areSelectedOptionsEqual
};
const defaultSelectionState = exports.defaultSelectionState = {
  exclude: false,
  existsSelected: false,
  selectedOptions: []
};
function initializeSelectionsManager(initialState) {
  var _initialState$selecte, _initialState$selecte2;
  const selectionsManager = (0, _state_manager.initializeStateManager)({
    ...initialState,
    selectedOptions: (_initialState$selecte = initialState.selectedOptions) !== null && _initialState$selecte !== void 0 ? _initialState$selecte : []
  }, defaultSelectionState, selectionComparators);
  return {
    ...selectionsManager,
    api: {
      ...selectionsManager.api,
      hasInitialSelections: ((_initialState$selecte2 = initialState.selectedOptions) === null || _initialState$selecte2 === void 0 ? void 0 : _initialState$selecte2.length) || initialState.existsSelected
    }
  };
}