"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WhatsNextBox = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _routes = require("../../routes");
var _connector_detail = require("../connector_detail");
var _encode_path_params = require("../../shared/encode_path_params");
var _react_router_helpers = require("../../shared/react_router_helpers");
var _syncs_context_menu = require("../../shared/header_actions/syncs_context_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WhatsNextBox = ({
  connectorId,
  connectorIndex,
  connectorStatus,
  disabled = false,
  isSyncing = false,
  isWaitingForConnector = false
}) => {
  const isConfigured = !(connectorStatus === _searchConnectors.ConnectorStatus.NEEDS_CONFIGURATION || connectorStatus === _searchConnectors.ConnectorStatus.CREATED);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    style: {
      position: 'relative'
    }
  }, isSyncing && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    position: "absolute"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.contentConnectors.whatsNextBox.whatsNextPanelLabel', {
    defaultMessage: "What's next?"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.contentConnectors.whatsNextBox.whatsNextPanelDescription', {
    defaultMessage: 'You can manually sync your data, schedule a recurring sync or see your documents.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    "data-test-subj": "entSearchContent-connector-configuration-setScheduleAndSync",
    "data-telemetry-id": "entSearchContent-connector-configuration-setScheduleAndSync",
    isDisabled: isWaitingForConnector || !connectorIndex || !isConfigured,
    to: `${(0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
      connectorId,
      tabId: _connector_detail.ConnectorDetailTabId.SCHEDULING
    })}`
  }, _i18n.i18n.translate('xpack.contentConnectors.content.connector_detail.configurationConnector.steps.schedule.button.label', {
    defaultMessage: 'Set schedule and sync'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_syncs_context_menu.SyncsContextMenu, {
    disabled: isWaitingForConnector || !connectorIndex || !isConfigured
  }))))));
};
exports.WhatsNextBox = WhatsNextBox;