"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoFindingsStates = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _use_csp_setup_status_api = require("@kbn/cloud-security-posture/src/hooks/use_csp_setup_status_api");
var _reactRouterDom = require("react-router-dom");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _empty_states_illustration_container = require("../empty_states_illustration_container");
var _use_wiz_integration_route = require("../../common/api/use_wiz_integration_route");
var _full_size_centered_page = require("../full_size_centered_page");
var _use_navigate_to_cis_integration_policies = require("../../common/navigation/use_navigate_to_cis_integration_policies");
var _test_subjects = require("../test_subjects");
var _cloud_posture_page = require("../cloud_posture_page");
var _clouds = _interopRequireDefault(require("../../assets/illustrations/clouds.svg"));
var _misconfigurations_vendors = _interopRequireDefault(require("../../assets/illustrations/misconfigurations_vendors.svg"));
var _use_csp_integration_link = require("../../common/navigation/use_csp_integration_link");
var _constants = require("../../common/constants");
var _constants2 = require("../../common/navigation/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NotDeployed = ({
  postureType
}) => {
  const integrationPoliciesLink = (0, _use_navigate_to_cis_integration_policies.useCISIntegrationPoliciesLink)({
    postureType
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": _test_subjects.NO_FINDINGS_STATUS_TEST_SUBJ.NO_AGENTS_DEPLOYED,
    color: "plain",
    iconType: "fleetApp",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.noFindingsStates.noAgentsDeployed.noAgentsDeployedTitle",
      defaultMessage: "No Agents Installed"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.noFindingsStates.noAgentsDeployed.noAgentsDeployedDescription",
      defaultMessage: "In order to begin detecting security misconfigurations, you'll need to deploy elastic-agent into the cloud account or Kubernetes cluster you want to monitor."
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      href: integrationPoliciesLink,
      isDisabled: !integrationPoliciesLink
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.noFindingsStates.noAgentsDeployed.noAgentsDeployedButtonTitle",
      defaultMessage: "Install Agent"
    }))]
  });
};
const Indexing = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": _test_subjects.NO_FINDINGS_STATUS_TEST_SUBJ.INDEXING,
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoSecurity",
    size: "xl"
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noFindingsStates.indexing.indexingButtonTitle",
    defaultMessage: "Posture evaluation underway"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noFindingsStates.indexing.indexingDescription",
    defaultMessage: "Waiting for data to be collected and indexed. Check back later to see your findings"
  }))
});
const IndexTimeout = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": _test_subjects.NO_FINDINGS_STATUS_TEST_SUBJ.INDEX_TIMEOUT,
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoSecurity",
    size: "xl"
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noFindingsStates.indexTimeout.indexTimeoutTitle",
    defaultMessage: "Waiting for Findings data"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noFindingsStates.indexTimeout.indexTimeoutDescription",
    defaultMessage: "Collecting findings is taking longer than expected. {docs}.",
    values: {
      docs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://ela.st/findings",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.noFindingsStates.indexTimeout.indexTimeoutDocLink",
        defaultMessage: "Learn more"
      }))
    }
  }))
});
const Unprivileged = ({
  unprivilegedIndices
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": _test_subjects.NO_FINDINGS_STATUS_TEST_SUBJ.UNPRIVILEGED,
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoSecurity",
    size: "xl"
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noFindingsStates.unprivileged.unprivilegedTitle",
    defaultMessage: "Privileges required"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noFindingsStates.unprivileged.unprivilegedDescription",
    defaultMessage: "To view cloud posture data, you must update privileges. For more information, contact your Kibana administrator."
  })),
  footer: /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    css: (0, _react2.css)`
          text-align: initial;
        `,
    children: _i18n.i18n.translate('xpack.csp.noFindingsStates.unprivileged.unprivilegedFooterMarkdown', {
      defaultMessage: 'Required Elasticsearch index privilege `read` for the following indices:'
    }) + unprivilegedIndices.map(idx => `\n- \`${idx}\``)
  })
});
const EmptySecurityFindingsPrompt = () => {
  const location = (0, _reactRouterDom.useLocation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const kspmIntegrationLink = (0, _use_csp_integration_link.useCspIntegrationLink)(_cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE);
  const cspmIntegrationLink = (0, _use_csp_integration_link.useCspIntegrationLink)(_cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE);
  const wizAddIntegrationLink = (0, _use_wiz_integration_route.useAdd3PIntegrationRoute)('wiz');
  const is3PSupportedPage = location.pathname.includes(_cloudSecurityPosture.findingsNavigation.findings_default.path);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    style: {
      padding: euiTheme.size.l
    },
    "data-test-subj": _cloud_posture_page.PACKAGE_NOT_INSTALLED_TEST_SUBJECT,
    icon: /*#__PURE__*/_react.default.createElement(_empty_states_illustration_container.EmptyStatesIllustrationContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: _clouds.default,
      alt: "clouds",
      role: "presentation"
    })),
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.packageNotInstalledRenderer.promptTitle",
      defaultMessage: "Elastic\u2019s Cloud Security {lineBreak} Posture Management",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", null)
      }
    })),
    layout: "vertical",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.packageNotInstalledRenderer.promptDescription",
      defaultMessage: "Detect and remediate potential configuration {lineBreak} risks in your cloud infrastructure, with our {lineBreak} Cloud and Kubernetes Security Posture {lineBreak} Management solutions. {learnMore}",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", null),
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _constants2.cspIntegrationDocsNavigation.cspm.overviewPath,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.cloudPosturePage.packageNotInstalledRenderer.learnMoreTitle",
          defaultMessage: "Learn more"
        }))
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: cspmIntegrationLink,
      isDisabled: !cspmIntegrationLink,
      "data-test-subj": _test_subjects.CSPM_NOT_INSTALLED_ACTION_SUBJ
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.packageNotInstalledRenderer.addCspmIntegrationButtonTitle",
      defaultMessage: "Add CSPM Integration"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: kspmIntegrationLink,
      isDisabled: !kspmIntegrationLink,
      "data-test-subj": _test_subjects.KSPM_NOT_INSTALLED_ACTION_SUBJ
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.packageNotInstalledRenderer.addKspmIntegrationButtonTitle",
      defaultMessage: "Add KSPM Integration"
    }))))
  })), is3PSupportedPage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    style: {
      padding: euiTheme.size.l
    },
    "data-test-subj": _test_subjects.THIRD_PARTY_INTEGRATIONS_NO_MISCONFIGURATIONS_FINDINGS_PROMPT,
    icon: /*#__PURE__*/_react.default.createElement(_empty_states_illustration_container.EmptyStatesIllustrationContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: _misconfigurations_vendors.default,
      alt: "misconfigurationsVendorsSVG",
      role: "presentation"
    })),
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.3pIntegrationsNoFindingsPrompt.promptTitle",
      defaultMessage: "Already using a {lineBreak} cloud security product?",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", null)
      }
    })),
    layout: "vertical",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.3pIntegrationsNoFindingsPrompt.promptDescription",
      defaultMessage: "Ingest data from your existing CSPM solution {lineBreak} for centralized analytics, hunting, {lineBreak} investigations, visualizations, and more. {lineBreak} Other integrations coming soon.",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", null)
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: wizAddIntegrationLink,
      isDisabled: !wizAddIntegrationLink,
      "data-test-subj": _test_subjects.THIRD_PARTY_NO_MISCONFIGURATIONS_FINDINGS_PROMPT_WIZ_INTEGRATION_BUTTON
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.3pIntegrationsNoFindingsPrompt.addWizIntegrationButtonTitle",
      defaultMessage: "Add Wiz Integration"
    }))))
  })));
};
const NoFindingsStatesNotification = ({
  postureType,
  status,
  indicesStatus,
  isNotInstalled
}) => {
  const unprivilegedIndices = indicesStatus && indicesStatus.filter(idxDetails => idxDetails.status === 'unprivileged').map(idxDetails => idxDetails.index).sort((a, b) => a.localeCompare(b));
  if (status === 'unprivileged') return /*#__PURE__*/_react.default.createElement(Unprivileged, {
    unprivilegedIndices: unprivilegedIndices || []
  });
  if (status === 'indexing' || status === 'waiting_for_results') return /*#__PURE__*/_react.default.createElement(Indexing, null);
  if (status === 'index-timeout') return /*#__PURE__*/_react.default.createElement(IndexTimeout, null);
  if (isNotInstalled) return /*#__PURE__*/_react.default.createElement(EmptySecurityFindingsPrompt, null);
  if (status === 'not-deployed') return /*#__PURE__*/_react.default.createElement(NotDeployed, {
    postureType: postureType
  });
  return null;
};

/**
 * This component will return the render states based on cloud posture setup status API
 * since 'not-installed' is being checked globally by CloudPosturePage and 'indexed' is the pass condition, those states won't be handled here
 * */
const NoFindingsStates = ({
  postureType
}) => {
  var _getSetupStatus$data, _getSetupStatus$data$, _getSetupStatus$data2, _getSetupStatus$data3, _getSetupStatus$data4;
  const getSetupStatus = (0, _use_csp_setup_status_api.useCspSetupStatusApi)({
    refetchInterval: _constants.NO_FINDINGS_STATUS_REFRESH_INTERVAL_MS
  });
  const statusKspm = (_getSetupStatus$data = getSetupStatus.data) === null || _getSetupStatus$data === void 0 ? void 0 : (_getSetupStatus$data$ = _getSetupStatus$data.kspm) === null || _getSetupStatus$data$ === void 0 ? void 0 : _getSetupStatus$data$.status;
  const statusCspm = (_getSetupStatus$data2 = getSetupStatus.data) === null || _getSetupStatus$data2 === void 0 ? void 0 : (_getSetupStatus$data3 = _getSetupStatus$data2.cspm) === null || _getSetupStatus$data3 === void 0 ? void 0 : _getSetupStatus$data3.status;
  const indicesStatus = (_getSetupStatus$data4 = getSetupStatus.data) === null || _getSetupStatus$data4 === void 0 ? void 0 : _getSetupStatus$data4.indicesDetails;
  const status = postureType === 'cspm' ? statusCspm : statusKspm;
  const isNotInstalled = statusKspm === 'not-installed' && statusCspm === 'not-installed';
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
    query: getSetupStatus
  }, /*#__PURE__*/_react.default.createElement(_full_size_centered_page.FullSizeCenteredPage, null, /*#__PURE__*/_react.default.createElement(NoFindingsStatesNotification, {
    postureType: postureType,
    status: status,
    indicesStatus: indicesStatus,
    isNotInstalled: isNotInstalled
  })));
};
exports.NoFindingsStates = NoFindingsStates;