"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterActivity = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilterActivity = exports.FilterActivity = /*#__PURE__*/_react.default.memo(({
  type,
  onFilterChange,
  userActionsStats,
  isLoading = false
}) => {
  const handleFilterChange = (0, _react.useCallback)(value => {
    if (value !== type) {
      onFilterChange(value);
    }
  }, [onFilterChange, type]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    "data-test-subj": "user-actions-filter-activity-group"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    withNext: true,
    grow: false,
    onClick: () => handleFilterChange('all'),
    isToggle: true,
    isSelected: type === 'all',
    hasActiveFilters: type === 'all',
    numFilters: userActionsStats && userActionsStats.total > 0 ? userActionsStats.total - userActionsStats.totalDeletions : 0,
    isLoading: isLoading,
    isDisabled: isLoading,
    "data-test-subj": "user-actions-filter-activity-button-all",
    iconSize: "s"
  }, i18n.ALL), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    withNext: true,
    grow: false,
    isToggle: true,
    isSelected: type === 'user',
    hasActiveFilters: type === 'user',
    numFilters: userActionsStats && userActionsStats.totalComments > 0 ? userActionsStats.totalComments - userActionsStats.totalCommentDeletions : 0,
    isLoading: isLoading,
    isDisabled: isLoading,
    onClick: () => handleFilterChange('user'),
    "data-test-subj": "user-actions-filter-activity-button-comments"
  }, i18n.COMMENTS), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: type === 'action',
    hasActiveFilters: type === 'action',
    numFilters: userActionsStats && userActionsStats.totalOtherActions > 0 ? userActionsStats.totalOtherActions - userActionsStats.totalOtherActionDeletions : 0,
    onClick: () => handleFilterChange('action'),
    isLoading: isLoading,
    isDisabled: isLoading,
    "data-test-subj": "user-actions-filter-activity-button-history"
  }, i18n.HISTORY));
});
FilterActivity.displayName = 'FilterActivity';