"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createActionAttachmentUserActionBuilder = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _timestamp = require("../timestamp");
var _copy_link = require("../copy_link");
var _markdown_editor = require("../../markdown_editor");
var _host_isolation_event = require("./host_isolation_event");
var _hoverable_user_with_avatar_resolver = require("../../user_profiles/hoverable_user_with_avatar_resolver");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createActionAttachmentUserActionBuilder = ({
  userAction,
  userProfiles,
  attachment,
  actionsNavigation
}) => ({
  build: () => {
    const actionIconName = attachment.actions.type === 'isolate' ? 'lock' : 'lockOpen';
    return [{
      username: /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar_resolver.HoverableUserWithAvatarResolver, {
        user: attachment.createdBy,
        userProfiles: userProfiles
      }),
      className: (0, _classnames.default)('comment-action', {
        'empty-comment': attachment.comment.trim().length === 0
      }),
      event: /*#__PURE__*/_react.default.createElement(_host_isolation_event.HostIsolationCommentEvent, {
        type: attachment.actions.type,
        endpoints: attachment.actions.targets,
        href: actionsNavigation === null || actionsNavigation === void 0 ? void 0 : actionsNavigation.href,
        onClick: actionsNavigation === null || actionsNavigation === void 0 ? void 0 : actionsNavigation.onClick
      }),
      'data-test-subj': 'endpoint-action',
      timestamp: /*#__PURE__*/_react.default.createElement(_timestamp.UserActionTimestamp, {
        createdAt: userAction.createdAt
      }),
      timelineAvatar: actionIconName,
      timelineAvatarAriaLabel: actionIconName,
      actions: /*#__PURE__*/_react.default.createElement(_copy_link.UserActionCopyLink, {
        id: attachment.id
      }),
      children: attachment.comment.trim().length > 0 && /*#__PURE__*/_react.default.createElement(_markdown_editor.ScrollableMarkdown, {
        content: attachment.comment
      })
    }];
  }
});
exports.createActionAttachmentUserActionBuilder = createActionAttachmentUserActionBuilder;