"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CLOSED_CASES = exports.BULK_ACTION_STATUS_OPEN = exports.BULK_ACTION_STATUS_IN_PROGRESS = exports.BULK_ACTION_STATUS_CLOSE = void 0;
Object.defineProperty(exports, "CLOSE_CASE", {
  enumerable: true,
  get: function () {
    return _translations.CLOSE_CASE;
  }
});
Object.defineProperty(exports, "MARK_CASE_IN_PROGRESS", {
  enumerable: true,
  get: function () {
    return _translations.MARK_CASE_IN_PROGRESS;
  }
});
exports.MARK_IN_PROGRESS_CASES = void 0;
Object.defineProperty(exports, "OPEN_CASE", {
  enumerable: true,
  get: function () {
    return _translations.OPEN_CASE;
  }
});
exports.REOPENED_CASES = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOSED_CASES = ({
  totalCases,
  caseTitle
}) => _i18n.i18n.translate('xpack.cases.actions.closedCases', {
  values: {
    caseTitle,
    totalCases
  },
  defaultMessage: 'Closed {totalCases, plural, =1 {"{caseTitle}"} other {{totalCases} cases}}'
});
exports.CLOSED_CASES = CLOSED_CASES;
const REOPENED_CASES = ({
  totalCases,
  caseTitle
}) => _i18n.i18n.translate('xpack.cases.actions.reopenedCases', {
  values: {
    caseTitle,
    totalCases
  },
  defaultMessage: 'Opened {totalCases, plural, =1 {"{caseTitle}"} other {{totalCases} cases}}'
});
exports.REOPENED_CASES = REOPENED_CASES;
const MARK_IN_PROGRESS_CASES = ({
  totalCases,
  caseTitle
}) => _i18n.i18n.translate('xpack.cases.actions.markInProgressCases', {
  values: {
    caseTitle,
    totalCases
  },
  defaultMessage: 'Marked {totalCases, plural, =1 {"{caseTitle}"} other {{totalCases} cases}} as in progress'
});
exports.MARK_IN_PROGRESS_CASES = MARK_IN_PROGRESS_CASES;
const BULK_ACTION_STATUS_CLOSE = exports.BULK_ACTION_STATUS_CLOSE = _i18n.i18n.translate('xpack.cases.actions.status.close', {
  defaultMessage: 'Close selected'
});
const BULK_ACTION_STATUS_OPEN = exports.BULK_ACTION_STATUS_OPEN = _i18n.i18n.translate('xpack.cases.actions.status.open', {
  defaultMessage: 'Open selected'
});
const BULK_ACTION_STATUS_IN_PROGRESS = exports.BULK_ACTION_STATUS_IN_PROGRESS = _i18n.i18n.translate('xpack.cases.actions.status.inProgress', {
  defaultMessage: 'Mark in progress'
});