"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VerticalPill = void 0;
var _shape_factory = require("../shape_factory");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VerticalPill = exports.VerticalPill = (0, _shape_factory.createShape)({
  viewBox: {
    minX: 0,
    minY: -8,
    width: 1,
    height: 208
  },
  shapeType: _types.SvgElementTypes.path,
  shapeProps: {
    d: 'M 1 200 L 1 0',
    strokeLinecap: 'round'
  },
  textAttributes: {
    x: '0',
    y: '-8',
    textAnchor: 'middle'
  }
});