"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCloneWorkpad = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _services = require("../../../services");
var _get_id = require("../../../lib/get_id");
var _canvas_workpad_service = require("../../../services/canvas_workpad_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCloneWorkpad = () => {
  const notifyService = (0, _services.useNotifyService)();
  const history = (0, _reactRouterDom.useHistory)();
  return (0, _react.useCallback)(async workpadId => {
    const workpadService = (0, _canvas_workpad_service.getCanvasWorkpadService)();
    try {
      let workpad = await workpadService.get(workpadId);
      workpad = {
        ...workpad,
        name: strings.getClonedWorkpadName(workpad.name),
        id: (0, _get_id.getId)('workpad')
      };
      await workpadService.create(workpad);
      history.push(`/workpad/${workpad.id}/page/1`);
    } catch (err) {
      notifyService.error(err, {
        title: errors.getCloneFailureErrorMessage()
      });
    }
  }, [notifyService, history]);
};
exports.useCloneWorkpad = useCloneWorkpad;
const strings = {
  getClonedWorkpadName: workpadName => _i18n.i18n.translate('xpack.canvas.useCloneWorkpad.clonedWorkpadName', {
    defaultMessage: 'Copy of {workpadName}',
    values: {
      workpadName
    },
    description: 'This suffix is added to the end of the name of a cloned workpad to indicate that this ' + 'new workpad is a copy of the original workpad. Example: "Copy of Sales Pitch"'
  })
};
const errors = {
  getCloneFailureErrorMessage: () => _i18n.i18n.translate('xpack.canvas.error.useCloneWorkpad.cloneFailureErrorMessage', {
    defaultMessage: `Couldn't clone workpad`
  })
};