"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveServiceDashbord = saveServiceDashbord;
var _custom_dashboards = require("../../../common/custom_dashboards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function saveServiceDashbord({
  savedObjectsClient,
  customDashboardId,
  serviceDashboard
}) {
  const {
    id,
    attributes,
    updated_at: updatedAt
  } = await (customDashboardId ? savedObjectsClient.update(_custom_dashboards.APM_CUSTOM_DASHBOARDS_SAVED_OBJECT_TYPE, customDashboardId, serviceDashboard) : savedObjectsClient.create(_custom_dashboards.APM_CUSTOM_DASHBOARDS_SAVED_OBJECT_TYPE, serviceDashboard));
  return {
    id,
    ...attributes,
    updatedAt: updatedAt ? Date.parse(updatedAt) : 0
  };
}