"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContainerDetails = ContainerDetails;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _formatters = require("../../../../common/utils/formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ContainerDetails({
  container,
  kubernetes
}) {
  if (!container) {
    return null;
  }
  const listItems = [];
  if (kubernetes !== null && kubernetes !== void 0 && kubernetes.containerImages && (kubernetes === null || kubernetes === void 0 ? void 0 : kubernetes.containerImages.length) > 0) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.container.image.name', {
        defaultMessage: 'Container images'
      }),
      description: /*#__PURE__*/_react.default.createElement("ul", null, kubernetes.containerImages.map((deployment, index) => /*#__PURE__*/_react.default.createElement("li", {
        key: index
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, deployment))))
    });
  }
  if (container.os) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.container.os.label', {
        defaultMessage: 'OS'
      }),
      description: container.os
    });
  }
  if (kubernetes !== null && kubernetes !== void 0 && kubernetes.deployments && (kubernetes === null || kubernetes === void 0 ? void 0 : kubernetes.deployments.length) > 0) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.kubernetes.deployments', {
        defaultMessage: 'Deployments'
      }),
      description: /*#__PURE__*/_react.default.createElement("ul", null, kubernetes.deployments.map((deployment, index) => /*#__PURE__*/_react.default.createElement("li", {
        key: index
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, deployment))))
    });
  }
  if (kubernetes !== null && kubernetes !== void 0 && kubernetes.namespaces && (kubernetes === null || kubernetes === void 0 ? void 0 : kubernetes.namespaces.length) > 0) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.kubernetes.namespaces', {
        defaultMessage: 'Namespaces'
      }),
      description: /*#__PURE__*/_react.default.createElement("ul", null, kubernetes.namespaces.map((namespace, index) => /*#__PURE__*/_react.default.createElement("li", {
        key: index
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, namespace))))
    });
  }
  if (kubernetes !== null && kubernetes !== void 0 && kubernetes.replicasets && (kubernetes === null || kubernetes === void 0 ? void 0 : kubernetes.replicasets.length) > 0) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.kubernetes.replicasets', {
        defaultMessage: 'Replicasets'
      }),
      description: /*#__PURE__*/_react.default.createElement("ul", null, kubernetes.replicasets.map((replicaset, index) => /*#__PURE__*/_react.default.createElement("li", {
        key: index
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, replicaset))))
    });
  }
  if (container.totalNumberInstances) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.container.totalNumberInstancesLabel', {
        defaultMessage: 'Total number of instances'
      }),
      description: (0, _formatters.asInteger)(container.totalNumberInstances)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    listItems: listItems
  });
}