"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Section = Section;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _keyValueMetadataTable = require("@kbn/key-value-metadata-table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Section({
  properties
}) {
  if (!(0, _lodash.isEmpty)(properties)) {
    return /*#__PURE__*/_react.default.createElement(_keyValueMetadataTable.KeyValueTable, {
      keyValuePairs: properties.map(property => ({
        key: property.field,
        value: property.value
      }))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.apm.propertiesTable.agentFeature.noDataAvailableLabel', {
    defaultMessage: 'No data available'
  }));
}