"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverLink = DiscoverLink;
exports.getDiscoverHref = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _url = _interopRequireDefault(require("url"));
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _rison_helpers = require("../rison_helpers");
var _use_adhoc_apm_data_view = require("../../../../hooks/use_adhoc_apm_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDiscoverHref = ({
  basePath,
  location,
  query,
  dataViewId
}) => {
  const risonQuery = {
    _g: (0, _rison_helpers.getTimepickerRisonData)(location.search),
    _a: {
      ...query._a,
      index: dataViewId
    }
  };
  const href = _url.default.format({
    pathname: basePath.prepend('/app/discover'),
    hash: `/?_g=${_rison.default.encode(risonQuery._g)}&_a=${_rison.default.encode(risonQuery._a)}`
  });
  return href;
};
exports.getDiscoverHref = getDiscoverHref;
function DiscoverLink({
  query = {},
  ...rest
}) {
  var _dataView$id;
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    dataView
  } = (0, _use_adhoc_apm_data_view.useAdHocApmDataView)();
  if (!dataView) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    });
  }
  const href = getDiscoverHref({
    basePath: core.http.basePath,
    query,
    location,
    dataViewId: (_dataView$id = dataView === null || dataView === void 0 ? void 0 : dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : ''
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "apmDiscoverLinkLink"
  }, rest, {
    href: href
  }));
}