"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeedbackModal = FeedbackModal;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _kibana_environment_context = require("../../../context/kibana_environment_context/kibana_environment_context");
var _get_path_for_feedback = require("../../../utils/get_path_for_feedback");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FeedbackModal({
  isFeedbackModalVisible = false,
  onClose
}) {
  const kibanaEnvironment = (0, _react.useContext)(_kibana_environment_context.KibanaEnvironmentContext);
  const {
    kibanaVersion,
    isCloudEnv,
    isServerlessEnv
  } = kibanaEnvironment;
  const sanitizedPath = (0, _get_path_for_feedback.getPathForFeedback)(window.location.pathname);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFeedbackModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    style: {
      width: '600px'
    },
    onCancel: onClose,
    onConfirm: onClose,
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      css: {
        color: euiTheme.colors.emptyShade
      },
      "data-test-subj": "xpack.apm.eemFeedback.button.open",
      iconType: "discuss",
      target: "_blank",
      size: "s",
      href: (0, _public.getSurveyFeedbackURL)({
        formUrl: 'https://ela.st/new-o11y-experience',
        kibanaVersion,
        isCloudEnv,
        isServerlessEnv,
        sanitizedPath
      })
    }, _i18n.i18n.translate('xpack.apm.eemFeedback.button.openSurvey', {
      defaultMessage: 'Tell us what you think!'
    })),
    defaultFocusedButton: "confirm",
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "center",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "heart",
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.eemFeedback.title', {
    defaultMessage: 'Let us know what you think!'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.feedbackModal.body.thanks', {
    defaultMessage: "Thank you for trying our new experience. We'll be continuing to improve on this so please come back often."
  }))))));
}