"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependencyMetricCharts = DependencyMetricCharts;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_breakpoints = require("../../../hooks/use_breakpoints");
var _dependency_failed_transaction_rate_chart = require("./dependency_failed_transaction_rate_chart");
var _dependency_latency_chart = require("./dependency_latency_chart");
var _dependency_throughput_chart = require("./dependency_throughput_chart");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DependencyMetricCharts() {
  const largeScreenOrSmaller = (0, _use_breakpoints.useBreakpoints)().isLarge;
  const {
    query,
    query: {
      dependencyName,
      rangeFrom,
      rangeTo,
      kuery,
      environment,
      comparisonEnabled,
      offset
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/dependencies/overview', '/dependencies/operation');
  const spanName = 'spanName' in query ? query.spanName : undefined;
  const props = {
    dependencyName,
    rangeFrom,
    rangeTo,
    kuery,
    environment,
    comparisonEnabled,
    offset,
    spanName
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: largeScreenOrSmaller ? 'column' : 'row',
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.dependencyDetailLatencyChartTitle', {
    defaultMessage: 'Latency'
  }))), /*#__PURE__*/_react.default.createElement(_dependency_latency_chart.DependencyLatencyChart, (0, _extends2.default)({
    height: 200
  }, props)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.dependencyDetailThroughputChartTitle', {
    defaultMessage: 'Throughput'
  }))), /*#__PURE__*/_react.default.createElement(_dependency_throughput_chart.DependencyThroughputChart, (0, _extends2.default)({
    height: 200
  }, props)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.dependencyDetailFailedTransactionRateChartTitle', {
    defaultMessage: 'Failed transaction rate'
  }))), /*#__PURE__*/_react.default.createElement(_dependency_failed_transaction_rate_chart.DependencyFailedTransactionRateChart, (0, _extends2.default)({
    height: 200
  }, props)))));
}