"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterWarning = FilterWarning;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FilterWarning({
  containerIds = [],
  hostNames = []
}) {
  const hasContainerIds = containerIds.length > 0;
  return hasContainerIds ? /*#__PURE__*/_react.default.createElement(FilterWarningToolTip, {
    values: containerIds,
    label: _i18n.i18n.translate('xpack.apm.profiling.topFunctions.filteredLabel.containerId', {
      defaultMessage: "Displaying profiling insights from the service's container id(s)"
    })
  }) : /*#__PURE__*/_react.default.createElement(FilterWarningToolTip, {
    values: hostNames,
    label: _i18n.i18n.translate('xpack.apm.profiling.topFunctions.filteredLabel.hostName', {
      defaultMessage: "Displaying profiling insights from the service's host(s)"
    })
  });
}
function FilterWarningToolTip({
  values = [],
  label
}) {
  function renderTooltipOptions() {
    return /*#__PURE__*/_react.default.createElement("ul", null, values.map(value => /*#__PURE__*/_react.default.createElement("li", {
      key: value
    }, `- ${value}`)));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: renderTooltipOptions(),
    type: "question"
  })));
}