"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileTransactionCharts = MobileTransactionCharts;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _annotations_context = require("../../../../context/annotations/annotations_context");
var _chart_pointer_event_context = require("../../../../context/chart_pointer_event/chart_pointer_event_context");
var _service_overview_throughput_chart = require("../../service_overview/service_overview_throughput_chart");
var _sessions_chart = require("../charts/sessions_chart");
var _http_requests_chart = require("../charts/http_requests_chart");
var _latency_chart = require("../../../shared/charts/latency_chart");
var _failed_transaction_rate_chart = require("../../../shared/charts/failed_transaction_rate_chart");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MobileTransactionCharts({
  serviceName,
  kuery,
  environment,
  start,
  end,
  transactionType,
  offset,
  comparisonEnabled
}) {
  return /*#__PURE__*/_react.default.createElement(_annotations_context.AnnotationsContextProvider, {
    serviceName: serviceName,
    environment: environment,
    start: start,
    end: end
  }, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-cy": 'mobile-transaction-session-chart'
  }, /*#__PURE__*/_react.default.createElement(_sessions_chart.SessionsChart, {
    kuery: kuery,
    start: start,
    end: end,
    environment: environment,
    serviceName: serviceName,
    transactionType: transactionType,
    offset: offset,
    comparisonEnabled: comparisonEnabled
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-cy": 'mobile-transaction-http-chart'
  }, /*#__PURE__*/_react.default.createElement(_http_requests_chart.HttpRequestsChart, {
    kuery: kuery,
    start: start,
    end: end,
    environment: environment,
    serviceName: serviceName,
    transactionType: transactionType,
    offset: offset,
    comparisonEnabled: comparisonEnabled
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-cy": 'mobile-transaction-duration-charts'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_latency_chart.LatencyChart, {
    kuery: kuery
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      flexShrink: 1
    }
  }, /*#__PURE__*/_react.default.createElement(_service_overview_throughput_chart.ServiceOverviewThroughputChart, {
    kuery: kuery
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_failed_transaction_rate_chart.FailedTransactionRateChart, {
    kuery: kuery
  })))));
}