"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileSearchBar = MobileSearchBar;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_breakpoints = require("../../../hooks/use_breakpoints");
var _time_comparison = require("../../shared/time_comparison");
var _filters = require("./service_overview/filters");
var _unified_search_bar = require("../../shared/unified_search_bar");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MobileSearchBar({
  hidden = false,
  showUnifiedSearchBar = true,
  showTimeComparison = false,
  showTransactionTypeSelector = false,
  showQueryInput = true,
  showMobileFilters = false,
  searchBarPlaceholder
}) {
  const {
    isSmall,
    isMedium,
    isLarge,
    isXl,
    isXXXL
  } = (0, _use_breakpoints.useBreakpoints)();
  if (hidden) {
    return null;
  }
  const searchBarDirection = isXXXL || !isXl && !showTimeComparison ? 'row' : 'column';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    direction: searchBarDirection
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: isLarge ? 'columnReverse' : 'row',
    gutterSize: "s",
    responsive: false
  }, showUnifiedSearchBar && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_unified_search_bar.UnifiedSearchBar, {
    placeholder: searchBarPlaceholder,
    showQueryInput: showQueryInput
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: isMedium ? 's' : 'm',
    direction: isLarge || isMedium ? 'column' : 'row'
  }, showTimeComparison && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isSmall
  }, /*#__PURE__*/_react.default.createElement(_time_comparison.TimeComparison, null)), showMobileFilters && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_filters.MobileFilters, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
}