"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmDataAccessPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _get_services = require("./services/get_services");
var _check_privileges = require("./lib/check_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ApmDataAccessPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = initContext.logger.get();
  }
  setup(core, plugins) {
    this.config = plugins.apmSourcesAccess.apmIndicesFromConfigFile;

    // expose
    return {
      // TODO: Deprecate and replace with apmSourcesAccess
      apmIndicesFromConfigFile: this.config,
      // TODO: Deprecate and replace with apmSourcesAccess
      getApmIndices: plugins.apmSourcesAccess.getApmIndices,
      getServices: _get_services.getServices
    };
  }
  start(core, plugins) {
    const getApmIndicesWithInternalUserFn = request => {
      const soClient = core.savedObjects.getScopedClient(request);
      return plugins.apmSourcesAccess.getApmIndices(soClient);
    };
    const startServices = {
      hasPrivileges: ({
        request
      }) => (0, _check_privileges.checkPrivileges)({
        request,
        getApmIndices: getApmIndicesWithInternalUserFn,
        security: plugins.security
      })
    };
    return startServices;
  }
  stop() {}
}
exports.ApmDataAccessPlugin = ApmDataAccessPlugin;