"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unsnoozeRuleRoute = void 0;
var _unsnooze = require("../../../../../../common/routes/rule/apis/unsnooze");
var _lib = require("../../../../../lib");
var _lib2 = require("../../../../lib");
var _types = require("../../../../../types");
var _transforms = require("./transforms");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const unsnoozeRuleRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rule/{id}/_unsnooze`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'internal'
    },
    validate: {
      params: _unsnooze.unsnoozeParamsInternalSchema,
      body: _unsnooze.unsnoozeBodyInternalSchema
    }
  }, router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const params = req.params;
    const body = (0, _transforms.transformUnsnoozeBodyV1)(req.body);
    try {
      await rulesClient.unsnooze({
        ...params,
        ...body
      });
      return res.noContent();
    } catch (e) {
      if (e instanceof _lib.RuleMutedError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  })));
};
exports.unsnoozeRuleRoute = unsnoozeRuleRoute;