"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logSuccessfulDeletion = exports.logFailedDeletion = void 0;
var _server = require("@kbn/event-log-plugin/server");
var _plugin = require("../../plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logSuccessfulDeletion = (context, runDate, numDeleted, spaceIds) => {
  const end = new Date();
  context.eventLogger.logEvent({
    '@timestamp': runDate.toISOString(),
    event: {
      action: _plugin.EVENT_LOG_ACTIONS.deleteAlerts,
      outcome: 'success',
      start: runDate.toISOString(),
      end: end.toISOString(),
      duration: (0, _server.millisToNanos)(end.getTime() - runDate.getTime())
    },
    message: `Alert deletion task deleted ${numDeleted} alerts`,
    kibana: {
      alert: {
        deletion: {
          num_deleted: numDeleted
        }
      },
      space_ids: spaceIds
    }
  });
};
exports.logSuccessfulDeletion = logSuccessfulDeletion;
const logFailedDeletion = (context, runDate, numDeleted, spaceIds, errMessage) => {
  const end = new Date();
  context.eventLogger.logEvent({
    '@timestamp': runDate.toISOString(),
    event: {
      action: _plugin.EVENT_LOG_ACTIONS.deleteAlerts,
      outcome: 'failure',
      start: runDate.toISOString(),
      end: end.toISOString(),
      duration: (0, _server.millisToNanos)(end.getTime() - runDate.getTime())
    },
    error: {
      message: errMessage
    },
    kibana: {
      alert: {
        deletion: {
          num_deleted: numDeleted
        }
      },
      space_ids: spaceIds
    }
  });
};
exports.logFailedDeletion = logFailedDeletion;