"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSkeletonCircleStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiSkeletonCircleStyles = exports.euiSkeletonCircleStyles = function euiSkeletonCircleStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiSkeletonCircle: /*#__PURE__*/(0, _react.css)("display:block;border-radius:50%;", (0, _utils.euiSkeletonGradientAnimation)(euiThemeContext, {
      slideSize: '-70%',
      gradientSize: '350%'
    }), " ", (0, _high_contrast.preventForcedColors)(euiThemeContext), ";;label:euiSkeletonCircle;"),
    // Sizes
    s: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size.l), ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size.xl), ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size.xxl), ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)((0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 4;
    })), ";;label:xl;")
  };
};