"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPageBody = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _restrict_width = require("../_restrict_width");
var _panel = require("../../panel");
var _global_styling = require("../../../global_styling");
var _page_body = require("./page_body.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "restrictWidth", "className", "css", "component", "panelled", "panelProps", "paddingSize", "borderRadius"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiPageBody = exports.EuiPageBody = function EuiPageBody(_ref) {
  var children = _ref.children,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
    className = _ref.className,
    css = _ref.css,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'div' : _ref$component,
    panelled = _ref.panelled,
    panelProps = _ref.panelProps,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _ref$borderRadius = _ref.borderRadius,
    borderRadius = _ref$borderRadius === void 0 ? 'none' : _ref$borderRadius,
    rest = _objectWithoutProperties(_ref, _excluded);
  // Set max-width as a style prop
  var widthStyles = (0, _restrict_width.setStyleForRestrictedPageWidth)(restrictWidth, rest === null || rest === void 0 ? void 0 : rest.style);

  // Shared
  var classes = (0, _classnames.default)('euiPageBody', className);
  var styles = (0, _page_body.euiPageBodyStyles)();
  var cssStyles = [styles.euiPageBody, restrictWidth && styles.restrictWidth];

  // Panelled
  var panelClasses = (0, _classnames.default)(classes, panelProps === null || panelProps === void 0 ? void 0 : panelProps.className);
  var panelCssStyles = [].concat(cssStyles, [panelProps === null || panelProps === void 0 ? void 0 : panelProps.css, css]);

  // Non-panelled
  var padding = (0, _global_styling.useEuiPaddingCSS)()[paddingSize];
  var componentCssStyles = [].concat(cssStyles, [padding, css]);
  return panelled ? (0, _react2.jsx)(_panel.EuiPanel, _extends({
    borderRadius: borderRadius,
    paddingSize: paddingSize
  }, panelProps, rest, {
    className: panelClasses,
    css: panelCssStyles
  }), children) : (0, _react2.jsx)(Component, _extends({}, rest, {
    className: classes,
    css: componentCssStyles,
    style: widthStyles
  }), children);
};