"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getInternalChartStateSelector = exports.chartSelectorsRegistry = void 0;
const create_selector_1 = require("../create_selector");
const chartSelectorsRegistryFactory = () => {
    let chartSelectorFactories;
    return {
        setChartSelectors: (d) => (chartSelectorFactories = d),
        getChartSelectors: (chartType) => {
            if (!chartSelectorFactories?.[chartType]) {
                throw new Error(`No chart selector factory found for chart type ${chartType}`);
            }
            return chartSelectorFactories[chartType]();
        },
    };
};
exports.chartSelectorsRegistry = chartSelectorsRegistryFactory();
exports.getInternalChartStateSelector = (0, create_selector_1.createCustomCachedSelector)([(state) => state.chartType], (chartType) => {
    if (chartType === null)
        return null;
    return exports.chartSelectorsRegistry.getChartSelectors(chartType);
});
//# sourceMappingURL=get_internal_chart_state.js.map