"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.chartSelectorsFactory = void 0;
const compute_legend_1 = require("./selectors/compute_legend");
const get_chart_type_description_1 = require("./selectors/get_chart_type_description");
const get_cursor_pointer_1 = require("./selectors/get_cursor_pointer");
const get_debug_state_1 = require("./selectors/get_debug_state");
const get_legend_items_labels_1 = require("./selectors/get_legend_items_labels");
const is_tooltip_visible_1 = require("./selectors/is_tooltip_visible");
const on_element_click_caller_1 = require("./selectors/on_element_click_caller");
const on_element_out_caller_1 = require("./selectors/on_element_out_caller");
const on_element_over_caller_1 = require("./selectors/on_element_over_caller");
const partition_spec_1 = require("./selectors/partition_spec");
const tooltip_1 = require("./selectors/tooltip");
const chart_selectors_1 = require("../../../state/chart_selectors");
const get_active_pointer_position_1 = require("../../../state/selectors/get_active_pointer_position");
const get_internal_is_intialized_1 = require("../../../state/selectors/get_internal_is_intialized");
exports.chartSelectorsFactory = (0, chart_selectors_1.createChartSelectorsFactory)({
    isInitialized: (state) => (0, partition_spec_1.getPartitionSpec)(state) !== null ? get_internal_is_intialized_1.InitStatus.Initialized : get_internal_is_intialized_1.InitStatus.SpecNotInitialized,
    isChartEmpty: () => false,
    getLegendItems: compute_legend_1.computeLegendSelector,
    getLegendItemsLabels: get_legend_items_labels_1.getLegendItemsLabels,
    getPointerCursor: get_cursor_pointer_1.getPointerCursorSelector,
    isTooltipVisible: (globalState) => ({
        visible: (0, is_tooltip_visible_1.isTooltipVisibleSelector)(globalState),
        isExternal: false,
        displayOnly: false,
        isPinnable: true,
    }),
    getTooltipInfo: tooltip_1.getTooltipInfoSelector,
    getTooltipAnchor: (state) => {
        const position = (0, get_active_pointer_position_1.getActivePointerPosition)(state);
        return {
            isRotated: false,
            x: position.x,
            width: 0,
            y: position.y,
            height: 0,
        };
    },
    getDebugState: get_debug_state_1.getDebugStateSelector,
    getChartTypeDescription: get_chart_type_description_1.getChartTypeDescriptionSelector,
}, [on_element_click_caller_1.createOnElementClickCaller, on_element_over_caller_1.createOnElementOverCaller, on_element_out_caller_1.createOnElementOutCaller]);
//# sourceMappingURL=chart_selectors.js.map