/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.test.rest.yaml.section.DoSection;
import org.elasticsearch.test.rest.yaml.section.ExecutableSection;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.elasticsearch.test.rest.yaml.section.PrerequisiteSection;
import org.elasticsearch.xcontent.XContentParser;

public class TeardownSection {
    public static final TeardownSection EMPTY = new TeardownSection(PrerequisiteSection.EMPTY, Collections.emptyList());
    private final PrerequisiteSection prerequisiteSection;
    private final List<ExecutableSection> doSections;

    static TeardownSection parseIfNext(XContentParser parser) throws IOException {
        ParserUtils.advanceToFieldName(parser);
        if ("teardown".equals(parser.currentName())) {
            parser.nextToken();
            TeardownSection section = TeardownSection.parse(parser);
            parser.nextToken();
            return section;
        }
        return EMPTY;
    }

    public static TeardownSection parse(XContentParser parser) throws IOException {
        PrerequisiteSection prerequisiteSection = PrerequisiteSection.parseIfNext(parser);
        ArrayList<ExecutableSection> executableSections = new ArrayList<ExecutableSection>();
        while (parser.currentToken() != XContentParser.Token.END_ARRAY) {
            ParserUtils.advanceToFieldName(parser);
            if (!"do".equals(parser.currentName())) {
                throw new ParsingException(parser.getTokenLocation(), "section [" + parser.currentName() + "] not supported within teardown section", new Object[0]);
            }
            executableSections.add(DoSection.parse(parser));
            parser.nextToken();
        }
        parser.nextToken();
        return new TeardownSection(prerequisiteSection, executableSections);
    }

    TeardownSection(PrerequisiteSection prerequisiteSection, List<ExecutableSection> doSections) {
        this.prerequisiteSection = Objects.requireNonNull(prerequisiteSection, "skip section cannot be null");
        this.doSections = Collections.unmodifiableList(doSections);
    }

    public PrerequisiteSection getPrerequisiteSection() {
        return this.prerequisiteSection;
    }

    public List<ExecutableSection> getDoSections() {
        return this.doSections;
    }

    public boolean isEmpty() {
        return EMPTY.equals(this);
    }
}

