/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.OrdinalBytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.LuceneOperator;
import org.elasticsearch.compute.lucene.LuceneSlice;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.lucene.PartialLeafReaderContext;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.lucene.ShardRefCounted;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class TimeSeriesSourceOperator
extends LuceneOperator {
    private static final TransportVersion ESQL_TIME_SERIES_SOURCE_STATUS = TransportVersion.fromId((int)9076000);
    private final int maxPageSize;
    private final BlockFactory blockFactory;
    private final LuceneSliceQueue sliceQueue;
    private int currentPagePos = 0;
    private int remainingDocs;
    private boolean doneCollecting;
    private LongVector.Builder timestampsBuilder;
    private TsidBuilder tsHashesBuilder;
    private SegmentsIterator iterator;
    private DocIdCollector docCollector;
    private long tsidsLoaded;

    TimeSeriesSourceOperator(List<? extends ShardContext> contexts, BlockFactory blockFactory, LuceneSliceQueue sliceQueue, int maxPageSize, int limit) {
        super(contexts, blockFactory, maxPageSize, sliceQueue);
        this.maxPageSize = maxPageSize;
        this.blockFactory = blockFactory;
        this.remainingDocs = limit;
        this.timestampsBuilder = blockFactory.newLongVectorBuilder(Math.min(limit, maxPageSize));
        this.tsHashesBuilder = new TsidBuilder(blockFactory, Math.min(limit, maxPageSize));
        this.sliceQueue = sliceQueue;
    }

    @Override
    public void finish() {
        this.doneCollecting = true;
    }

    @Override
    public boolean isFinished() {
        return this.doneCollecting;
    }

    @Override
    public Page getCheckedOutput() throws IOException {
        if (this.isFinished()) {
            return null;
        }
        if (this.remainingDocs <= 0) {
            this.doneCollecting = true;
            return null;
        }
        Page page = null;
        Releasable[] blocks = new Block[3];
        long startInNanos = System.nanoTime();
        try {
            if (this.iterator == null) {
                LuceneSlice slice = this.sliceQueue.nextSlice();
                if (slice == null) {
                    this.doneCollecting = true;
                    Page page2 = null;
                    return page2;
                }
                if (!slice.tags().isEmpty()) {
                    throw new UnsupportedOperationException("tags not supported by " + String.valueOf(this.getClass()));
                }
                this.iterator = new SegmentsIterator(slice);
                this.docCollector = new DocIdCollector(this.blockFactory, slice.shardContext());
            }
            this.iterator.readDocsForNextPage();
            if (this.currentPagePos > 0) {
                blocks[0] = this.docCollector.build().asBlock();
                OrdinalBytesRefVector tsidVector = this.tsHashesBuilder.build();
                blocks[1] = tsidVector.asBlock();
                this.tsHashesBuilder = new TsidBuilder(this.blockFactory, Math.min(this.remainingDocs, this.maxPageSize));
                blocks[2] = this.timestampsBuilder.build().asBlock();
                this.timestampsBuilder = this.blockFactory.newLongVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                page = new Page(this.currentPagePos, (Block[])blocks);
                this.currentPagePos = 0;
            }
            if (this.iterator.completed()) {
                this.processedShards.add(this.iterator.luceneSlice.shardContext().shardIdentifier());
                ++this.processedSlices;
                Releasables.close((Releasable)this.docCollector);
                this.iterator = null;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (page == null) {
                Releasables.closeExpectNoException((Releasable[])blocks);
            }
            this.processingNanos += System.nanoTime() - startInNanos;
        }
        return page;
    }

    @Override
    public void additionalClose() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.timestampsBuilder, this.tsHashesBuilder, this.docCollector});
    }

    @Override
    protected void describe(StringBuilder sb) {
        sb.append("[maxPageSize=").append(this.maxPageSize).append(", remainingDocs=").append(this.remainingDocs).append("]");
    }

    @Override
    public Operator.Status status() {
        long valuesLoaded = this.rowsEmitted;
        return new Status(this, this.tsidsLoaded, valuesLoaded);
    }

    static final class TsidBuilder
    implements Releasable {
        private int currentOrd = -1;
        private final BytesRefVector.Builder dictBuilder;
        private final IntVector.Builder ordinalsBuilder;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TsidBuilder(BlockFactory blockFactory, int estimatedSize) {
            BytesRefVector.Builder dictBuilder = blockFactory.newBytesRefVectorBuilder(estimatedSize);
            boolean success = false;
            try {
                this.dictBuilder = dictBuilder;
                this.ordinalsBuilder = blockFactory.newIntVectorBuilder(estimatedSize);
                success = true;
            }
            finally {
                if (!success) {
                    dictBuilder.close();
                }
            }
        }

        void appendNewTsid(BytesRef tsid) {
            ++this.currentOrd;
            this.dictBuilder.appendBytesRef(tsid);
        }

        void appendOrdinal() {
            assert (this.currentOrd >= 0);
            this.ordinalsBuilder.appendInt(this.currentOrd);
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.dictBuilder, this.ordinalsBuilder});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        OrdinalBytesRefVector build() throws IOException {
            BytesRefVector dict = null;
            OrdinalBytesRefVector result = null;
            IntVector ordinals = null;
            try {
                dict = this.dictBuilder.build();
                ordinals = this.ordinalsBuilder.build();
                result = new OrdinalBytesRefVector(ordinals, dict);
                if (result != null) return result;
            }
            catch (Throwable throwable) {
                if (result != null) throw throwable;
                Releasables.close((Releasable[])new Releasable[]{dict, ordinals});
                throw throwable;
            }
            Releasables.close((Releasable[])new Releasable[]{dict, ordinals});
            return result;
        }
    }

    class SegmentsIterator {
        private final PriorityQueue<LeafIterator> mainQueue;
        private final PriorityQueue<LeafIterator> oneTsidQueue;
        final LuceneSlice luceneSlice;

        SegmentsIterator(LuceneSlice luceneSlice) throws IOException {
            this.luceneSlice = luceneSlice;
            this.mainQueue = new PriorityQueue<LeafIterator>(this, luceneSlice.numLeaves()){

                protected boolean lessThan(LeafIterator a, LeafIterator b) {
                    return a.timeSeriesHash.compareTo(b.timeSeriesHash) < 0;
                }
            };
            Weight weight = luceneSlice.weight();
            TimeSeriesSourceOperator.this.processedQueries.add(weight.getQuery());
            int maxSegmentOrd = 0;
            for (PartialLeafReaderContext leafReaderContext : luceneSlice.leaves()) {
                LeafIterator leafIterator = new LeafIterator(weight, leafReaderContext.leafReaderContext());
                leafIterator.nextDoc();
                if (leafIterator.docID == Integer.MAX_VALUE) continue;
                this.mainQueue.add((Object)leafIterator);
                maxSegmentOrd = Math.max(maxSegmentOrd, leafIterator.segmentOrd);
            }
            this.oneTsidQueue = new PriorityQueue<LeafIterator>(this, this.mainQueue.size()){

                protected boolean lessThan(LeafIterator a, LeafIterator b) {
                    return a.timestamp > b.timestamp;
                }
            };
        }

        void readDocsForNextPage() throws IOException {
            PriorityQueue<LeafIterator> sub;
            TimeSeriesSourceOperator.this.docCollector.prepareForCollecting(Math.min(TimeSeriesSourceOperator.this.remainingDocs, TimeSeriesSourceOperator.this.maxPageSize));
            Thread executingThread = Thread.currentThread();
            for (LeafIterator leaf : this.mainQueue) {
                leaf.reinitializeIfNeeded(executingThread);
            }
            for (LeafIterator leaf : this.oneTsidQueue) {
                leaf.reinitializeIfNeeded(executingThread);
            }
            while ((sub = this.subQueueForNextTsid()).size() != 0) {
                TimeSeriesSourceOperator.this.tsHashesBuilder.appendNewTsid(((LeafIterator)sub.top()).timeSeriesHash);
                if (!this.readValuesForOneTsid(sub) && this.mainQueue.size() > 0) continue;
            }
        }

        private boolean readValuesForOneTsid(PriorityQueue<LeafIterator> sub) throws IOException {
            do {
                LeafIterator top = (LeafIterator)sub.top();
                ++TimeSeriesSourceOperator.this.currentPagePos;
                --TimeSeriesSourceOperator.this.remainingDocs;
                TimeSeriesSourceOperator.this.docCollector.collect(top.segmentOrd, top.docID);
                TimeSeriesSourceOperator.this.tsHashesBuilder.appendOrdinal();
                TimeSeriesSourceOperator.this.timestampsBuilder.appendLong(top.timestamp);
                if (top.nextDoc()) {
                    sub.updateTop();
                } else if (top.docID == Integer.MAX_VALUE) {
                    sub.pop();
                } else {
                    this.mainQueue.add((Object)((LeafIterator)sub.pop()));
                }
                if (TimeSeriesSourceOperator.this.remainingDocs > 0 && TimeSeriesSourceOperator.this.currentPagePos < TimeSeriesSourceOperator.this.maxPageSize) continue;
                return true;
            } while (sub.size() > 0);
            return false;
        }

        private PriorityQueue<LeafIterator> subQueueForNextTsid() {
            if (this.oneTsidQueue.size() == 0 && this.mainQueue.size() > 0) {
                LeafIterator last = (LeafIterator)this.mainQueue.pop();
                this.oneTsidQueue.add((Object)last);
                while (this.mainQueue.size() > 0) {
                    LeafIterator top = (LeafIterator)this.mainQueue.top();
                    if (!top.timeSeriesHash.equals((Object)last.timeSeriesHash)) break;
                    this.oneTsidQueue.add((Object)((LeafIterator)this.mainQueue.pop()));
                }
                if (this.oneTsidQueue.size() > 0) {
                    ++TimeSeriesSourceOperator.this.tsidsLoaded;
                }
            }
            return this.oneTsidQueue;
        }

        boolean completed() {
            return this.mainQueue.size() == 0 && this.oneTsidQueue.size() == 0;
        }
    }

    static final class DocIdCollector
    implements Releasable {
        private final BlockFactory blockFactory;
        private final ShardContext shardContext;
        private IntVector.Builder docsBuilder;
        private IntVector.Builder segmentsBuilder;

        DocIdCollector(BlockFactory blockFactory, ShardContext shardContext) {
            this.blockFactory = blockFactory;
            this.shardContext = shardContext;
        }

        void prepareForCollecting(int estimatedSize) {
            assert (this.docsBuilder == null);
            this.docsBuilder = this.blockFactory.newIntVectorBuilder(estimatedSize);
            this.segmentsBuilder = this.blockFactory.newIntVectorBuilder(estimatedSize);
        }

        void collect(int segment, int docId) {
            this.docsBuilder.appendInt(docId);
            this.segmentsBuilder.appendInt(segment);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DocVector build() {
            DocVector docVector;
            block3: {
                IntVector shards = null;
                IntVector segments = null;
                IntVector docs = null;
                DocVector docVector2 = null;
                try {
                    docs = this.docsBuilder.build();
                    this.docsBuilder = null;
                    segments = this.segmentsBuilder.build();
                    this.segmentsBuilder = null;
                    shards = this.blockFactory.newConstantIntVector(this.shardContext.index(), docs.getPositionCount());
                    docVector = docVector2 = new DocVector(ShardRefCounted.fromShardContext(this.shardContext), shards, segments, docs, segments.isConstant());
                    if (docVector2 != null) break block3;
                }
                catch (Throwable throwable) {
                    if (docVector2 == null) {
                        Releasables.close((Releasable[])new Releasable[]{docs, segments, shards});
                    }
                    throw throwable;
                }
                Releasables.close((Releasable[])new Releasable[]{docs, segments, shards});
            }
            return docVector;
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.docsBuilder, this.segmentsBuilder});
        }
    }

    public static class Status
    extends LuceneOperator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "time_series_source", Status::new);
        private final long tsidLoaded;
        private final long valuesLoaded;

        Status(TimeSeriesSourceOperator operator, long tsidLoaded, long valuesLoaded) {
            super(operator);
            this.tsidLoaded = tsidLoaded;
            this.valuesLoaded = valuesLoaded;
        }

        Status(int processedSlices, Set<String> processedQueries, Set<String> processedShards, long processNanos, int sliceIndex, int totalSlices, int pagesEmitted, int sliceMin, int sliceMax, int current, long rowsEmitted, Map<String, LuceneSliceQueue.PartitioningStrategy> partitioningStrategies, long tsidLoaded, long valuesLoaded) {
            super(processedSlices, processedQueries, processedShards, processNanos, sliceIndex, totalSlices, pagesEmitted, sliceMin, sliceMax, current, rowsEmitted, partitioningStrategies);
            this.tsidLoaded = tsidLoaded;
            this.valuesLoaded = valuesLoaded;
        }

        Status(StreamInput in) throws IOException {
            super(in);
            this.tsidLoaded = in.readVLong();
            this.valuesLoaded = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVLong(this.tsidLoaded);
            out.writeVLong(this.valuesLoaded);
        }

        @Override
        protected void toXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            super.toXContentFields(builder, params);
            builder.field("tsid_loaded", this.tsidLoaded);
            builder.field("values_loaded", this.valuesLoaded);
        }

        public long tsidLoaded() {
            return this.tsidLoaded;
        }

        @Override
        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public boolean supportsVersion(TransportVersion version) {
            return version.supports(ESQL_TIME_SERIES_SOURCE_STATUS);
        }

        @Override
        public long valuesLoaded() {
            return this.valuesLoaded;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Status status = (Status)o;
            return this.tsidLoaded == status.tsidLoaded && this.valuesLoaded == status.valuesLoaded;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.tsidLoaded, this.valuesLoaded);
        }
    }

    static class LeafIterator {
        private final int segmentOrd;
        private final Weight weight;
        private final LeafReaderContext leafContext;
        private SortedDocValues tsids;
        private NumericDocValues timestamps;
        private DocIdSetIterator disi;
        private Thread createdThread;
        private long timestamp;
        private int lastTsidOrd = -1;
        private BytesRef timeSeriesHash;
        private int docID = -1;

        LeafIterator(Weight weight, LeafReaderContext leafContext) throws IOException {
            this.segmentOrd = leafContext.ord;
            this.weight = weight;
            this.leafContext = leafContext;
            this.createdThread = Thread.currentThread();
            this.tsids = leafContext.reader().getSortedDocValues("_tsid");
            this.timestamps = DocValues.unwrapSingleton((SortedNumericDocValues)leafContext.reader().getSortedNumericDocValues("@timestamp"));
            Scorer scorer = weight.scorer(leafContext);
            this.disi = scorer != null ? scorer.iterator() : DocIdSetIterator.empty();
        }

        boolean nextDoc() throws IOException {
            this.docID = this.disi.nextDoc();
            if (this.docID == Integer.MAX_VALUE) {
                return false;
            }
            boolean advanced = this.timestamps.advanceExact(this.docID);
            assert (advanced);
            this.timestamp = this.timestamps.longValue();
            advanced = this.tsids.advanceExact(this.docID);
            assert (advanced);
            int ord = this.tsids.ordValue();
            if (ord != this.lastTsidOrd) {
                this.timeSeriesHash = this.tsids.lookupOrd(ord);
                this.lastTsidOrd = ord;
                return false;
            }
            return true;
        }

        void reinitializeIfNeeded(Thread executingThread) throws IOException {
            if (executingThread != this.createdThread) {
                this.tsids = this.leafContext.reader().getSortedDocValues("_tsid");
                this.timestamps = DocValues.unwrapSingleton((SortedNumericDocValues)this.leafContext.reader().getSortedNumericDocValues("@timestamp"));
                Scorer scorer = this.weight.scorer(this.leafContext);
                DocIdSetIterator docIdSetIterator = this.disi = scorer != null ? scorer.iterator() : DocIdSetIterator.empty();
                if (this.docID != -1) {
                    this.disi.advance(this.docID);
                }
                this.createdThread = executingThread;
            }
        }
    }
}

