/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.spatial.PointType;
import org.elasticsearch.compute.aggregation.spatial.SpatialAggregationUtils;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentAggregator;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentGroupingState;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentState;

class SpatialExtentCartesianShapeSourceValuesAggregator
extends SpatialExtentAggregator {
    SpatialExtentCartesianShapeSourceValuesAggregator() {
    }

    public static SpatialExtentState initSingle() {
        return new SpatialExtentState(PointType.CARTESIAN);
    }

    public static SpatialExtentGroupingState initGrouping() {
        return new SpatialExtentGroupingState(PointType.CARTESIAN);
    }

    public static void combine(SpatialExtentState current, BytesRef bytes) {
        current.add(SpatialAggregationUtils.decode(bytes));
    }

    public static void combine(SpatialExtentGroupingState current, int groupId, BytesRef bytes) {
        current.add(groupId, SpatialAggregationUtils.decode(bytes));
    }
}

