/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopLongAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopLongGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopLongAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopLongAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopLongAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopLongGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopLongAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopLongAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopLongGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopLongGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top of longs";
    }
}

