/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.LastOverTimeFloatAggregator;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class LastOverTimeFloatGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("timestamps", ElementType.LONG), new IntermediateStateDesc("values", ElementType.FLOAT));
    private final LastOverTimeFloatAggregator.GroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public LastOverTimeFloatGroupingAggregatorFunction(List<Integer> channels, LastOverTimeFloatAggregator.GroupingState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static LastOverTimeFloatGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new LastOverTimeFloatGroupingAggregatorFunction(channels, LastOverTimeFloatAggregator.initGrouping(driverContext), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final FloatBlock valuesBlock = (FloatBlock)page.getBlock(this.channels.get(0));
        final FloatVector valuesVector = valuesBlock.asVector();
        LongBlock timestampsBlock = (LongBlock)page.getBlock(this.channels.get(1));
        final LongVector timestampsVector = timestampsBlock.asVector();
        if (timestampsVector == null) {
            throw new IllegalStateException("expected @timestamp vector; but got a block");
        }
        if (valuesVector == null) {
            if (valuesBlock.mayHaveNulls()) {
                this.state.enableGroupIdTracking(seenGroupIds);
            }
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    LastOverTimeFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock, timestampsVector);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    LastOverTimeFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock, timestampsVector);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    LastOverTimeFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock, timestampsVector);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                LastOverTimeFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector, timestampsVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                LastOverTimeFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector, timestampsVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                LastOverTimeFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector, timestampsVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, FloatBlock values, LongVector timestamps) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                if (values.isNull(groupPosition + positionOffset)) continue;
                int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
                int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
                for (int v = valuesStart; v < valuesEnd; ++v) {
                    LastOverTimeFloatAggregator.combine(this.state, groupId, timestamps.getLong(v), values.getFloat(v));
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, FloatVector values, LongVector timestamps) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuePosition = groupPosition + positionOffset;
                LastOverTimeFloatAggregator.combine(this.state, groupId, timestamps.getLong(valuePosition), values.getFloat(valuePosition));
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, FloatBlock values, LongVector timestamps) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                if (values.isNull(groupPosition + positionOffset)) continue;
                int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
                int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
                for (int v = valuesStart; v < valuesEnd; ++v) {
                    LastOverTimeFloatAggregator.combine(this.state, groupId, timestamps.getLong(v), values.getFloat(v));
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, FloatVector values, LongVector timestamps) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuePosition = groupPosition + positionOffset;
                LastOverTimeFloatAggregator.combine(this.state, groupId, timestamps.getLong(valuePosition), values.getFloat(valuePosition));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, FloatBlock values, LongVector timestamps) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            if (values.isNull(groupPosition + positionOffset)) continue;
            int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
            int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
            for (int v = valuesStart; v < valuesEnd; ++v) {
                LastOverTimeFloatAggregator.combine(this.state, groupId, timestamps.getLong(v), values.getFloat(v));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, FloatVector values, LongVector timestamps) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuePosition = groupPosition + positionOffset;
            LastOverTimeFloatAggregator.combine(this.state, groupId, timestamps.getLong(valuePosition), values.getFloat(valuePosition));
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object timestampsUncast = page.getBlock(this.channels.get(0));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongBlock timestamps = (LongBlock)timestampsUncast;
        Object valuesUncast = page.getBlock(this.channels.get(1));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        FloatBlock values = (FloatBlock)valuesUncast;
        assert (timestamps.getPositionCount() == values.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            LastOverTimeFloatAggregator.combineIntermediate(this.state, groupId, timestamps, values, groupPosition + positionOffset);
        }
    }

    @Override
    public void addIntermediateRowInput(int groupId, GroupingAggregatorFunction input, int position) {
        if (input.getClass() != this.getClass()) {
            throw new IllegalArgumentException("expected " + String.valueOf(this.getClass()) + "; got " + String.valueOf(input.getClass()));
        }
        LastOverTimeFloatAggregator.GroupingState inState = ((LastOverTimeFloatGroupingAggregatorFunction)input).state;
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        LastOverTimeFloatAggregator.combineStates(this.state, groupId, inState, position);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext evaluatorContext) {
        blocks[offset] = LastOverTimeFloatAggregator.evaluateFinal(this.state, selected, evaluatorContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

