/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.indices.breaker.CircuitBreakerMetrics;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.test.InternalAggregationTestCase;
import org.hamcrest.Matchers;
import org.mockito.Mockito;

public abstract class InternalMultiBucketAggregationTestCase<T extends InternalAggregation>
extends InternalAggregationTestCase<T> {
    private static final int DEFAULT_MAX_NUMBER_OF_BUCKETS = 10;
    private Supplier<InternalAggregations> subAggregationsSupplier;
    private int maxNumberOfBuckets = 10;

    protected int randomNumberOfBuckets() {
        return InternalMultiBucketAggregationTestCase.randomIntBetween(this.minNumberOfBuckets(), this.maxNumberOfBuckets());
    }

    protected int minNumberOfBuckets() {
        return 0;
    }

    protected int maxNumberOfBuckets() {
        return this.maxNumberOfBuckets;
    }

    public void setMaxNumberOfBuckets(int maxNumberOfBuckets) {
        this.maxNumberOfBuckets = maxNumberOfBuckets;
    }

    public void setSubAggregationsSupplier(Supplier<InternalAggregations> subAggregationsSupplier) {
        this.subAggregationsSupplier = subAggregationsSupplier;
    }

    public final InternalAggregations createSubAggregations() {
        return this.subAggregationsSupplier.get();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.subAggregationsSupplier = InternalMultiBucketAggregationTestCase.randomBoolean() ? () -> InternalAggregations.EMPTY : () -> {
            int numSubAggs = InternalMultiBucketAggregationTestCase.randomIntBetween(1, 3);
            ArrayList<T> aggs = new ArrayList<T>();
            for (int i = 0; i < numSubAggs; ++i) {
                aggs.add(this.createTestInstanceForXContent(InternalMultiBucketAggregationTestCase.randomAlphaOfLength(5), Collections.emptyMap(), InternalAggregations.EMPTY));
            }
            return InternalAggregations.from(aggs);
        };
    }

    @Override
    protected final T createTestInstance(String name, Map<String, Object> metadata) {
        T instance = this.createTestInstance(name, metadata, this.subAggregationsSupplier.get());
        assert (((MultiBucketsAggregation)instance).getBuckets().size() <= this.maxNumberOfBuckets()) : "Maximum number of buckets exceeded for " + instance.getClass().getSimpleName() + " aggregation";
        return instance;
    }

    protected abstract T createTestInstance(String var1, Map<String, Object> var2, InternalAggregations var3);

    @Override
    public final T createTestInstanceForXContent() {
        return this.createTestInstanceForXContent(InternalMultiBucketAggregationTestCase.randomAlphaOfLength(5), this.createTestMetadata(), this.createSubAggregations());
    }

    protected T createTestInstanceForXContent(String name, Map<String, Object> metadata, InternalAggregations subAggs) {
        return this.createTestInstance(name, metadata, subAggs);
    }

    @Override
    protected void assertSampled(T sampled, T reduced, SamplingContext samplingContext) {
        this.assertBucketCountsScaled(((MultiBucketsAggregation)sampled).getBuckets(), ((MultiBucketsAggregation)reduced).getBuckets(), samplingContext);
    }

    protected void assertBucketCountsScaled(List<? extends MultiBucketsAggregation.Bucket> sampled, List<? extends MultiBucketsAggregation.Bucket> reduced, SamplingContext samplingContext) {
        InternalMultiBucketAggregationTestCase.assertEquals((long)sampled.size(), (long)reduced.size());
        Iterator<? extends MultiBucketsAggregation.Bucket> sampledIt = sampled.iterator();
        for (MultiBucketsAggregation.Bucket bucket : reduced) {
            MultiBucketsAggregation.Bucket sampledBucket = sampledIt.next();
            InternalMultiBucketAggregationTestCase.assertEquals((long)sampledBucket.getDocCount(), (long)samplingContext.scaleUp(bucket.getDocCount()));
        }
    }

    @Override
    public void doAssertReducedMultiBucketConsumer(Aggregation agg, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
    }

    protected static void expectReduceUsesTooManyBuckets(InternalAggregation agg, final int bucketLimit) {
        AggregationReduceContext.ForFinal reduceContext = new AggregationReduceContext.ForFinal(BigArrays.NON_RECYCLING_INSTANCE, null, () -> false, (AggregationBuilder)Mockito.mock(AggregationBuilder.class), new IntConsumer(){
            int buckets;

            @Override
            public void accept(int value) {
                this.buckets += value;
                if (this.buckets > bucketLimit) {
                    throw new IllegalArgumentException("too big!");
                }
            }
        }, PipelineAggregator.PipelineTree.EMPTY);
        Exception e = (Exception)InternalMultiBucketAggregationTestCase.expectThrows(IllegalArgumentException.class, () -> InternalMultiBucketAggregationTestCase.lambda$expectReduceUsesTooManyBuckets$3(agg, (AggregationReduceContext)reduceContext));
        InternalMultiBucketAggregationTestCase.assertThat(e.getMessage(), Matchers.equalTo((Object)"too big!"));
    }

    protected static void expectReduceThrowsRealMemoryBreaker(InternalAggregation agg) {
        HierarchyCircuitBreakerService breaker = new HierarchyCircuitBreakerService(CircuitBreakerMetrics.NOOP, Settings.builder().put(HierarchyCircuitBreakerService.TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING.getKey(), "50%").build(), List.of(), new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS)){

            public void checkParentLimit(long newBytesReserved, String label) throws CircuitBreakingException {
                super.checkParentLimit(newBytesReserved, label);
            }
        };
        AggregationReduceContext.ForFinal reduceContext = new AggregationReduceContext.ForFinal(BigArrays.NON_RECYCLING_INSTANCE, null, () -> false, (AggregationBuilder)Mockito.mock(AggregationBuilder.class), v -> breaker.getBreaker("request").addEstimateBytesAndMaybeBreak(0L, "test"), PipelineAggregator.PipelineTree.EMPTY);
        Exception e = (Exception)InternalMultiBucketAggregationTestCase.expectThrows(CircuitBreakingException.class, () -> InternalMultiBucketAggregationTestCase.lambda$expectReduceThrowsRealMemoryBreaker$6(agg, (AggregationReduceContext)reduceContext));
        InternalMultiBucketAggregationTestCase.assertThat(e.getMessage(), Matchers.startsWith((String)"[parent] Data too large, data for [test] "));
    }

    private static /* synthetic */ void lambda$expectReduceThrowsRealMemoryBreaker$6(InternalAggregation agg, AggregationReduceContext reduceContext) throws Throwable {
        InternalAggregationTestCase.reduce(List.of(agg), reduceContext);
    }

    private static /* synthetic */ void lambda$expectReduceUsesTooManyBuckets$3(InternalAggregation agg, AggregationReduceContext reduceContext) throws Throwable {
        InternalAggregationTestCase.reduce(List.of(agg), reduceContext);
    }
}

