/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.plugin.RemoteClusterPlan;
import org.elasticsearch.xpack.esql.session.Configuration;

final class ClusterComputeRequest
extends AbstractTransportRequest
implements IndicesRequest.Replaceable {
    private final String clusterAlias;
    private final String sessionId;
    private final Configuration configuration;
    private final RemoteClusterPlan plan;
    private transient String[] indices;

    ClusterComputeRequest(String clusterAlias, String sessionId, Configuration configuration, RemoteClusterPlan plan) {
        this.clusterAlias = clusterAlias;
        this.sessionId = sessionId;
        this.configuration = configuration;
        this.plan = plan;
        this.indices = plan.originalIndices().indices();
    }

    ClusterComputeRequest(StreamInput in) throws IOException {
        super(in);
        this.clusterAlias = in.readString();
        this.sessionId = in.readString();
        this.configuration = new Configuration(new BlockStreamInput(in, new BlockFactory((CircuitBreaker)new NoopCircuitBreaker("request"), BigArrays.NON_RECYCLING_INSTANCE)));
        this.plan = RemoteClusterPlan.from(new PlanStreamInput(in, in.namedWriteableRegistry(), this.configuration));
        this.indices = this.plan.originalIndices().indices();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.clusterAlias);
        out.writeString(this.sessionId);
        this.configuration.writeTo(out);
        this.plan.writeTo(new PlanStreamOutput(out, this.configuration));
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public IndicesOptions indicesOptions() {
        return this.plan.originalIndices().indicesOptions();
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        if (!parentTaskId.isSet()) {
            assert (false) : "DataNodeRequest must have a parent task";
            throw new IllegalStateException("DataNodeRequest must have a parent task");
        }
        return new CancellableTask(id, type, action, "", parentTaskId, headers){

            public String getDescription() {
                return ClusterComputeRequest.this.getDescription();
            }
        };
    }

    String clusterAlias() {
        return this.clusterAlias;
    }

    String sessionId() {
        return this.sessionId;
    }

    Configuration configuration() {
        return this.configuration;
    }

    RemoteClusterPlan remoteClusterPlan() {
        return this.plan;
    }

    public String getDescription() {
        return "plan=" + String.valueOf(this.plan);
    }

    public String toString() {
        return "ClusterComputeRequest{" + this.getDescription() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ClusterComputeRequest request = (ClusterComputeRequest)((Object)o);
        return this.clusterAlias.equals(request.clusterAlias) && this.sessionId.equals(request.sessionId) && this.configuration.equals(request.configuration) && this.plan.equals(request.plan) && this.getParentTask().equals((Object)request.getParentTask());
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.configuration, this.plan);
    }
}

