/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.grouping.Bucket;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public class TimeSeriesAggregate
extends Aggregate {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "TimeSeriesAggregate", TimeSeriesAggregate::new);
    private final Bucket timeBucket;

    public TimeSeriesAggregate(Source source, LogicalPlan child, List<Expression> groupings, List<? extends NamedExpression> aggregates, Bucket timeBucket) {
        super(source, child, groupings, aggregates);
        this.timeBucket = timeBucket;
    }

    public TimeSeriesAggregate(StreamInput in) throws IOException {
        super(in);
        this.timeBucket = (Bucket)in.readOptionalWriteable(inp -> (Bucket)Bucket.ENTRY.reader.read(inp));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.timeBucket);
    }

    @Override
    public String getWriteableName() {
        return TimeSeriesAggregate.ENTRY.name;
    }

    protected NodeInfo<Aggregate> info() {
        return NodeInfo.create((Node)this, TimeSeriesAggregate::new, (Object)((Object)this.child()), (Object)this.groupings, (Object)this.aggregates, (Object)this.timeBucket);
    }

    @Override
    public TimeSeriesAggregate replaceChild(LogicalPlan newChild) {
        return new TimeSeriesAggregate(this.source(), newChild, this.groupings, this.aggregates, this.timeBucket);
    }

    @Override
    public TimeSeriesAggregate with(LogicalPlan child, List<Expression> newGroupings, List<? extends NamedExpression> newAggregates) {
        return new TimeSeriesAggregate(this.source(), child, newGroupings, newAggregates, this.timeBucket);
    }

    @Nullable
    public Bucket timeBucket() {
        return this.timeBucket;
    }
}

