/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.LimitExec;
import org.elasticsearch.xpack.esql.plan.physical.ParallelExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.TimeSeriesAggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.TimeSeriesFieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.TimeSeriesSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;

public class ParallelizeTimeSeriesSource
extends PhysicalOptimizerRules.ParameterizedOptimizerRule<TimeSeriesAggregateExec, LocalPhysicalOptimizerContext> {
    @Override
    public PhysicalPlan rule(TimeSeriesAggregateExec plan, LocalPhysicalOptimizerContext context) {
        if (plan.getMode().isInputPartial()) {
            return plan;
        }
        if (!plan.anyMatch(p -> {
            EsQueryExec q;
            return p instanceof EsQueryExec && (q = (EsQueryExec)p).indexMode() == IndexMode.TIME_SERIES;
        })) {
            return plan;
        }
        ArrayList pushDownExtracts = new ArrayList();
        plan.forEachDown(p -> {
            if (p instanceof FieldExtractExec) {
                pushDownExtracts.add((FieldExtractExec)p);
            } else if (ParallelizeTimeSeriesSource.stopPushDownExtract(p) && !pushDownExtracts.isEmpty()) {
                pushDownExtracts.clear();
            }
        });
        Holder aborted = new Holder((Object)Boolean.FALSE);
        PhysicalPlan newChild = (PhysicalPlan)plan.child().transformUp(PhysicalPlan.class, p -> {
            EsQueryExec q;
            if (((Boolean)aborted.get()).booleanValue()) {
                return p;
            }
            if (p instanceof EsQueryExec && (q = (EsQueryExec)p).indexMode() == IndexMode.TIME_SERIES) {
                return this.addFieldExtract(context, q, pushDownExtracts);
            }
            if (ParallelizeTimeSeriesSource.stopPushDownExtract(p)) {
                aborted.set((Object)Boolean.TRUE);
                return p;
            }
            if (p instanceof FieldExtractExec) {
                FieldExtractExec e = (FieldExtractExec)p;
                return e.child();
            }
            return p;
        });
        return plan.replaceChild(new ParallelExec(plan.source(), newChild));
    }

    private static boolean stopPushDownExtract(PhysicalPlan p) {
        return p instanceof FilterExec || p instanceof TopNExec || p instanceof LimitExec;
    }

    private PhysicalPlan addFieldExtract(LocalPhysicalOptimizerContext context, EsQueryExec query, List<FieldExtractExec> extracts) {
        HashSet<Attribute> docValuesAttributes = new HashSet<Attribute>();
        HashSet<Attribute> boundsAttributes = new HashSet<Attribute>();
        ArrayList<Attribute> attributesToExtract = new ArrayList<Attribute>();
        for (FieldExtractExec extract : extracts) {
            docValuesAttributes.addAll(extract.docValuesAttributes());
            boundsAttributes.addAll(extract.boundsAttributes());
            attributesToExtract.addAll(extract.attributesToExtract());
        }
        List<Attribute> attrs = query.attrs();
        TimeSeriesSourceExec tsSource = new TimeSeriesSourceExec(query.source(), attrs, query.query(), query.limit(), query.estimatedRowSize());
        return new TimeSeriesFieldExtractExec(query.source(), new ParallelExec(query.source(), tsSource), attributesToExtract, context.configuration().pragmas().fieldExtractPreference(), docValuesAttributes, boundsAttributes);
    }
}

