/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.time.DateTimeException;
import java.time.temporal.TemporalAmount;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Sub;

public final class SubDateNanosEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SubDateNanosEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator dateNanos;
    private final TemporalAmount temporalAmount;
    private final DriverContext driverContext;
    private Warnings warnings;

    public SubDateNanosEvaluator(Source source, EvalOperator.ExpressionEvaluator dateNanos, TemporalAmount temporalAmount, DriverContext driverContext) {
        this.source = source;
        this.dateNanos = dateNanos;
        this.temporalAmount = temporalAmount;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock dateNanosBlock = (LongBlock)this.dateNanos.eval(page);){
            LongVector dateNanosVector = dateNanosBlock.asVector();
            if (dateNanosVector == null) {
                LongBlock longBlock = this.eval(page.getPositionCount(), dateNanosBlock);
                return longBlock;
            }
            LongBlock longBlock = this.eval(page.getPositionCount(), dateNanosVector);
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.dateNanos.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, LongBlock dateNanosBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (dateNanosBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (dateNanosBlock.getValueCount(p) != 1) {
                    if (dateNanosBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendLong(Sub.processDateNanos(dateNanosBlock.getLong(dateNanosBlock.getFirstValueIndex(p)), this.temporalAmount));
                    continue;
                }
                catch (ArithmeticException | DateTimeException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongVector dateNanosVector) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendLong(Sub.processDateNanos(dateNanosVector.getLong(p), this.temporalAmount));
                    continue;
                }
                catch (ArithmeticException | DateTimeException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "SubDateNanosEvaluator[dateNanos=" + String.valueOf(this.dateNanos) + ", temporalAmount=" + String.valueOf(this.temporalAmount) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.dateNanos);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory dateNanos;
        private final TemporalAmount temporalAmount;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory dateNanos, TemporalAmount temporalAmount) {
            this.source = source;
            this.dateNanos = dateNanos;
            this.temporalAmount = temporalAmount;
        }

        public SubDateNanosEvaluator get(DriverContext context) {
            return new SubDateNanosEvaluator(this.source, this.dateNanos.get(context), this.temporalAmount, context);
        }

        public String toString() {
            return "SubDateNanosEvaluator[dateNanos=" + String.valueOf(this.dateNanos) + ", temporalAmount=" + String.valueOf(this.temporalAmount) + "]";
        }
    }
}

