/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateParse;

public final class DateParseConstantEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DateParseConstantEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator val;
    private final DateFormatter formatter;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DateParseConstantEvaluator(Source source, EvalOperator.ExpressionEvaluator val, DateFormatter formatter, DriverContext driverContext) {
        this.source = source;
        this.val = val;
        this.formatter = formatter;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock valBlock = (BytesRefBlock)this.val.eval(page);){
            BytesRefVector valVector = valBlock.asVector();
            if (valVector == null) {
                LongBlock longBlock = this.eval(page.getPositionCount(), valBlock);
                return longBlock;
            }
            LongBlock longBlock = this.eval(page.getPositionCount(), valVector);
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.val.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, BytesRefBlock valBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            BytesRef valScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valBlock.getValueCount(p) != 1) {
                    if (valBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendLong(DateParse.process(valBlock.getBytesRef(valBlock.getFirstValueIndex(p), valScratch), this.formatter));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, BytesRefVector valVector) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            BytesRef valScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendLong(DateParse.process(valVector.getBytesRef(p, valScratch), this.formatter));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "DateParseConstantEvaluator[val=" + String.valueOf(this.val) + ", formatter=" + String.valueOf(this.formatter) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.val);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory val;
        private final DateFormatter formatter;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory val, DateFormatter formatter) {
            this.source = source;
            this.val = val;
            this.formatter = formatter;
        }

        public DateParseConstantEvaluator get(DriverContext context) {
            return new DateParseConstantEvaluator(this.source, this.val.get(context), this.formatter, context);
        }

        public String toString() {
            return "DateParseConstantEvaluator[val=" + String.valueOf(this.val) + ", formatter=" + String.valueOf(this.formatter) + "]";
        }
    }
}

