/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.AbstractConfusionMatrixMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.OutlierDetection;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.ScoreByThresholdResult;

public class Recall
extends AbstractConfusionMatrixMetric {
    public static final ParseField NAME = new ParseField("recall", new String[0]);
    private static final ConstructingObjectParser<Recall, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), a -> new Recall((List)a[0]));

    public static Recall fromXContent(XContentParser parser) {
        return (Recall)PARSER.apply(parser, null);
    }

    public Recall(List<Double> at) {
        super(at);
    }

    public Recall(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return MlEvaluationNamedXContentProvider.registeredMetricName(OutlierDetection.NAME, NAME);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recall that = (Recall)o;
        return Arrays.equals(this.thresholds, that.thresholds);
    }

    public int hashCode() {
        return Arrays.hashCode(this.thresholds);
    }

    @Override
    protected List<AggregationBuilder> aggsAt(String actualField, String predictedProbabilityField) {
        ArrayList<AggregationBuilder> aggs = new ArrayList<AggregationBuilder>();
        for (int i = 0; i < this.thresholds.length; ++i) {
            double threshold = this.thresholds[i];
            aggs.add(this.buildAgg(actualField, predictedProbabilityField, threshold, AbstractConfusionMatrixMetric.Condition.TP));
            aggs.add(this.buildAgg(actualField, predictedProbabilityField, threshold, AbstractConfusionMatrixMetric.Condition.FN));
        }
        return aggs;
    }

    @Override
    public EvaluationMetricResult evaluate(InternalAggregations aggs) {
        double[] recalls = new double[this.thresholds.length];
        for (int i = 0; i < this.thresholds.length; ++i) {
            long fn;
            double threshold = this.thresholds[i];
            SingleBucketAggregation tpAgg = (SingleBucketAggregation)aggs.get(this.aggName(threshold, AbstractConfusionMatrixMetric.Condition.TP));
            SingleBucketAggregation fnAgg = (SingleBucketAggregation)aggs.get(this.aggName(threshold, AbstractConfusionMatrixMetric.Condition.FN));
            long tp = tpAgg.getDocCount();
            recalls[i] = tp + (fn = fnAgg.getDocCount()) == 0L ? 0.0 : (double)tp / (double)(tp + fn);
        }
        return new ScoreByThresholdResult(NAME.getPreferredName(), this.thresholds, recalls);
    }

    static {
        PARSER.declareDoubleArray(ConstructingObjectParser.constructorArg(), AT);
    }
}

