/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.step.info.SingleMessageFieldInfo;

public class WaitForActiveShardsStep
extends ClusterStateWaitStep {
    public static final String NAME = "wait-for-active-shards";
    private static final Logger logger = LogManager.getLogger(WaitForActiveShardsStep.class);

    WaitForActiveShardsStep(Step.StepKey key, Step.StepKey nextStepKey) {
        super(key, nextStepKey);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ProjectState currentState) {
        String waitForActiveShardsSettingValue;
        String rolledIndexName;
        IndexMetadata originalIndexMeta = currentState.metadata().index(index);
        if (originalIndexMeta == null) {
            String errorMessage = Strings.format((String)"[%s] lifecycle action for index [%s] executed but index no longer exists", (Object[])new Object[]{this.getKey().action(), index.getName()});
            logger.debug(errorMessage);
            return new ClusterStateWaitStep.Result(false, new SingleMessageFieldInfo(errorMessage));
        }
        boolean indexingComplete = (Boolean)LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING.get(originalIndexMeta.getSettings());
        if (indexingComplete) {
            String message = Strings.format((String)"index [%s] has lifecycle complete set, skipping [%s]", (Object[])new Object[]{originalIndexMeta.getIndex().getName(), NAME});
            logger.trace(message);
            return new ClusterStateWaitStep.Result(true, new SingleMessageFieldInfo(message));
        }
        IndexAbstraction indexAbstraction = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(index.getName());
        DataStream dataStream = indexAbstraction.getParentDataStream();
        if (dataStream != null) {
            IndexAbstraction dataStreamAbstraction = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(dataStream.getName());
            assert (dataStreamAbstraction != null) : dataStream.getName() + " datastream is not present in the metadata indices lookup";
            Index rolledIndex = dataStream.isFailureStoreIndex(index.getName()) ? dataStream.getWriteFailureIndex() : dataStream.getWriteIndex();
            if (rolledIndex == null) {
                return WaitForActiveShardsStep.getErrorResultOnNullMetadata(this.getKey(), index);
            }
            IndexMetadata rolledIndexMeta = currentState.metadata().index(rolledIndex);
            rolledIndexName = rolledIndexMeta.getIndex().getName();
            waitForActiveShardsSettingValue = rolledIndexMeta.getSettings().get(IndexMetadata.SETTING_WAIT_FOR_ACTIVE_SHARDS.getKey());
        } else {
            String rolloverAlias = (String)RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING.get(originalIndexMeta.getSettings());
            if (Strings.isNullOrEmpty((String)rolloverAlias)) {
                throw new IllegalStateException("setting [index.lifecycle.rollover_alias] is not set on index [" + originalIndexMeta.getIndex().getName() + "]");
            }
            IndexAbstraction aliasAbstraction = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(rolloverAlias);
            assert (aliasAbstraction.getType() == IndexAbstraction.Type.ALIAS) : rolloverAlias + " must be an alias but it is not";
            Index aliasWriteIndex = aliasAbstraction.getWriteIndex();
            if (aliasWriteIndex != null) {
                IndexMetadata writeIndexImd = currentState.metadata().index(aliasWriteIndex);
                rolledIndexName = writeIndexImd.getIndex().getName();
                waitForActiveShardsSettingValue = writeIndexImd.getSettings().get(IndexMetadata.SETTING_WAIT_FOR_ACTIVE_SHARDS.getKey());
            } else {
                List indices = aliasAbstraction.getIndices();
                int maxIndexCounter = -1;
                Index tmpRolledIndex = null;
                for (Index i : indices) {
                    int indexNameCounter = IndexMetadata.parseIndexNameCounter((String)i.getName());
                    if (maxIndexCounter >= indexNameCounter) continue;
                    maxIndexCounter = indexNameCounter;
                    tmpRolledIndex = i;
                }
                if (tmpRolledIndex == null) {
                    return WaitForActiveShardsStep.getErrorResultOnNullMetadata(this.getKey(), index);
                }
                rolledIndexName = tmpRolledIndex.getName();
                waitForActiveShardsSettingValue = currentState.metadata().index(rolledIndexName).getSettings().get("index.write.wait_for_active_shards");
            }
        }
        ActiveShardCount activeShardCount = ActiveShardCount.parseString((String)waitForActiveShardsSettingValue);
        boolean enoughShardsActive = activeShardCount.enoughShardsActive(currentState.metadata(), currentState.routingTable(), new String[]{rolledIndexName});
        IndexRoutingTable indexRoutingTable = currentState.routingTable().index(rolledIndexName);
        int currentActiveShards = 0;
        for (int i = 0; i < indexRoutingTable.size(); ++i) {
            currentActiveShards += indexRoutingTable.shard(i).activeShards().size();
        }
        return new ClusterStateWaitStep.Result(enoughShardsActive, new ActiveShardsInfo(currentActiveShards, activeShardCount.toString(), enoughShardsActive));
    }

    private static ClusterStateWaitStep.Result getErrorResultOnNullMetadata(Step.StepKey key, Index originalIndex) {
        String errorMessage = Strings.format((String)"unable to find the index that was rolled over from [%s] as part of lifecycle action [%s]", (Object[])new Object[]{originalIndex.getName(), key.action()});
        logger.debug(errorMessage);
        return new ClusterStateWaitStep.Result(false, new SingleMessageFieldInfo(errorMessage));
    }

    static final class ActiveShardsInfo
    implements ToXContentObject {
        private final long currentActiveShardsCount;
        private final String targetActiveShardsCount;
        private final boolean enoughShardsActive;
        private final String message;
        static final ParseField CURRENT_ACTIVE_SHARDS_COUNT = new ParseField("current_active_shards_count", new String[0]);
        static final ParseField TARGET_ACTIVE_SHARDS_COUNT = new ParseField("target_active_shards_count", new String[0]);
        static final ParseField ENOUGH_SHARDS_ACTIVE = new ParseField("enough_shards_active", new String[0]);
        static final ParseField MESSAGE = new ParseField("message", new String[0]);

        ActiveShardsInfo(long currentActiveShardsCount, String targetActiveShardsCount, boolean enoughShardsActive) {
            this.currentActiveShardsCount = currentActiveShardsCount;
            this.targetActiveShardsCount = targetActiveShardsCount;
            this.enoughShardsActive = enoughShardsActive;
            this.message = enoughShardsActive ? "the target of [" + targetActiveShardsCount + "] are active. Don't need to wait anymore" : "waiting for [" + targetActiveShardsCount + "] shards to become active, but only [" + currentActiveShardsCount + "] are active";
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MESSAGE.getPreferredName(), this.message);
            builder.field(CURRENT_ACTIVE_SHARDS_COUNT.getPreferredName(), this.currentActiveShardsCount);
            builder.field(TARGET_ACTIVE_SHARDS_COUNT.getPreferredName(), this.targetActiveShardsCount);
            builder.field(ENOUGH_SHARDS_ACTIVE.getPreferredName(), this.enoughShardsActive);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActiveShardsInfo info = (ActiveShardsInfo)o;
            return this.currentActiveShardsCount == info.currentActiveShardsCount && this.enoughShardsActive == info.enoughShardsActive && Objects.equals(this.targetActiveShardsCount, info.targetActiveShardsCount) && Objects.equals(this.message, info.message);
        }

        public int hashCode() {
            return Objects.hash(this.currentActiveShardsCount, this.targetActiveShardsCount, this.enoughShardsActive, this.message);
        }
    }
}

