/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.codec.vectors.reflect.OffHeapByteSizeUtils;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class DenseVectorStats
implements Writeable,
ToXContentFragment {
    private static final TransportVersion DENSE_VECTOR_OFF_HEAP_STATS = TransportVersion.fromName("dense_vector_off_heap_stats");
    private long valueCount = 0L;
    Map<String, Map<String, Long>> offHeapStats;
    public static final String INCLUDE_OFF_HEAP = "include_off_heap";
    public static final String INCLUDE_PER_FIELD_STATS = "include_per_field_stats";

    public DenseVectorStats() {
    }

    public DenseVectorStats(long count) {
        this(count, null);
    }

    public DenseVectorStats(long count, Map<String, Map<String, Long>> offHeapStats) {
        this.valueCount = count;
        this.offHeapStats = offHeapStats;
    }

    public DenseVectorStats(StreamInput in) throws IOException {
        this.valueCount = in.readVLong();
        if (in.getTransportVersion().supports(DENSE_VECTOR_OFF_HEAP_STATS)) {
            this.offHeapStats = this.readOptionalOffHeapStats(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.valueCount);
        if (out.getTransportVersion().supports(DENSE_VECTOR_OFF_HEAP_STATS)) {
            this.writeOptionalOffHeapStats(out);
        }
    }

    private Map<String, Map<String, Long>> readOptionalOffHeapStats(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            return in.readMap(v -> in.readMap(StreamInput::readLong));
        }
        return null;
    }

    private void writeOptionalOffHeapStats(StreamOutput out) throws IOException {
        if (this.offHeapStats != null) {
            out.writeBoolean(true);
            out.writeMap(this.offHeapStats, StreamOutput::writeString, DenseVectorStats::writeFieldStatsMap);
        } else {
            out.writeBoolean(false);
        }
    }

    static void writeFieldStatsMap(StreamOutput out, Map<String, Long> map) throws IOException {
        out.writeMap(map, StreamOutput::writeString, StreamOutput::writeLong);
    }

    public void add(DenseVectorStats other) {
        if (other == null) {
            return;
        }
        this.valueCount += other.valueCount;
        if (other.offHeapStats != null) {
            this.offHeapStats = this.offHeapStats == null ? other.offHeapStats : Stream.of(this.offHeapStats, other.offHeapStats).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, OffHeapByteSizeUtils::mergeOffHeapByteSizeMaps));
        }
    }

    public long getValueCount() {
        return this.valueCount;
    }

    public Map<String, Map<String, Long>> offHeapStats() {
        return this.offHeapStats;
    }

    private Map<String, Long> getTotalsByCategory() {
        if (this.offHeapStats == null) {
            return Map.of("veb", 0L, "vec", 0L, "veq", 0L, "vex", 0L);
        }
        return this.offHeapStats.entrySet().stream().flatMap(map -> ((Map)map.getValue()).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Long::sum));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("dense_vector");
        builder.field("value_count", this.valueCount);
        if (params.paramAsBoolean(INCLUDE_OFF_HEAP, false)) {
            this.toXContentWithFields(builder, params);
        }
        builder.endObject();
        return builder;
    }

    private void toXContentWithFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Map<String, Long> totals = this.getTotalsByCategory();
        builder.startObject("off_heap");
        builder.humanReadableField("total_size_bytes", "total_size", (Object)ByteSizeValue.ofBytes(totals.values().stream().mapToLong(Long::longValue).sum()));
        builder.humanReadableField("total_veb_size_bytes", "total_veb_size", (Object)ByteSizeValue.ofBytes(totals.getOrDefault("veb", 0L)));
        builder.humanReadableField("total_vec_size_bytes", "total_vec_size", (Object)ByteSizeValue.ofBytes(totals.getOrDefault("vec", 0L)));
        builder.humanReadableField("total_veq_size_bytes", "total_veq_size", (Object)ByteSizeValue.ofBytes(totals.getOrDefault("veq", 0L)));
        builder.humanReadableField("total_vex_size_bytes", "total_vex_size", (Object)ByteSizeValue.ofBytes(totals.getOrDefault("vex", 0L)));
        if (params.paramAsBoolean(INCLUDE_PER_FIELD_STATS, false) && this.offHeapStats != null && this.offHeapStats.size() > 0) {
            this.toXContentWithPerFieldStats(builder);
        }
        builder.endObject();
    }

    private void toXContentWithPerFieldStats(XContentBuilder builder) throws IOException {
        builder.startObject("fielddata");
        for (String key : this.offHeapStats.keySet().stream().sorted().toList()) {
            Map<String, Long> entry = this.offHeapStats.get(key);
            if (entry.isEmpty()) continue;
            builder.startObject(key);
            for (String eKey : entry.keySet().stream().sorted().toList()) {
                long value = entry.get(eKey);
                assert (value > 0L);
                builder.humanReadableField(eKey + "_size_bytes", eKey + "_size", (Object)ByteSizeValue.ofBytes(value));
            }
            builder.endObject();
        }
        builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DenseVectorStats that = (DenseVectorStats)o;
        return this.valueCount == that.valueCount && Objects.equals(this.offHeapStats, that.offHeapStats);
    }

    public int hashCode() {
        return Objects.hash(this.valueCount, this.offHeapStats);
    }

    static final class Fields {
        static final String NAME = "dense_vector";
        static final String VALUE_COUNT = "value_count";
        static final String FIELDS = "fielddata";

        Fields() {
        }
    }
}

