/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.FieldArrayContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.XContentBuilder;

final class SortedSetWithOffsetsDocValuesSyntheticFieldLoaderLayer
implements CompositeSyntheticFieldLoader.DocValuesLayer {
    private final String name;
    private final String offsetsFieldName;
    private final Function<BytesRef, BytesRef> converter;
    private DocValuesWithOffsetsLoader docValues;

    SortedSetWithOffsetsDocValuesSyntheticFieldLoaderLayer(String name, String offsetsFieldName) {
        this(name, offsetsFieldName, Function.identity());
    }

    SortedSetWithOffsetsDocValuesSyntheticFieldLoaderLayer(String name, String offsetsFieldName, Function<BytesRef, BytesRef> converter) {
        this.name = Objects.requireNonNull(name);
        this.offsetsFieldName = Objects.requireNonNull(offsetsFieldName);
        this.converter = Objects.requireNonNull(converter);
    }

    @Override
    public String fieldName() {
        return this.name;
    }

    @Override
    public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
        SortedSetDocValues valueDocValues = DocValues.getSortedSet((LeafReader)leafReader, (String)this.name);
        SortedDocValues offsetDocValues = DocValues.getSorted((LeafReader)leafReader, (String)this.offsetsFieldName);
        this.docValues = new DocValuesWithOffsetsLoader(valueDocValues, offsetDocValues, this.converter);
        return this.docValues;
    }

    @Override
    public boolean hasValue() {
        if (this.docValues != null) {
            return this.docValues.count() > 0;
        }
        return false;
    }

    @Override
    public long valueCount() {
        if (this.docValues != null) {
            return this.docValues.count();
        }
        return 0L;
    }

    @Override
    public void write(XContentBuilder b) throws IOException {
        if (this.docValues != null) {
            this.docValues.write(b);
        }
    }

    static final class DocValuesWithOffsetsLoader
    implements SourceLoader.SyntheticFieldLoader.DocValuesLoader {
        private final SortedDocValues offsetDocValues;
        private final SortedSetDocValues valueDocValues;
        private final Function<BytesRef, BytesRef> converter;
        private final ByteArrayStreamInput scratch = new ByteArrayStreamInput();
        private boolean hasValue;
        private boolean hasOffset;
        private int[] offsetToOrd;

        DocValuesWithOffsetsLoader(SortedSetDocValues valueDocValues, SortedDocValues offsetDocValues, Function<BytesRef, BytesRef> converter) {
            this.valueDocValues = valueDocValues;
            this.offsetDocValues = offsetDocValues;
            this.converter = converter;
        }

        @Override
        public boolean advanceToDoc(int docId) throws IOException {
            this.hasValue = this.valueDocValues.advanceExact(docId);
            this.hasOffset = this.offsetDocValues.advanceExact(docId);
            if (this.hasValue || this.hasOffset) {
                if (this.hasOffset) {
                    int offsetOrd = this.offsetDocValues.ordValue();
                    BytesRef encodedValue = this.offsetDocValues.lookupOrd(offsetOrd);
                    this.scratch.reset(encodedValue.bytes, encodedValue.offset, encodedValue.length);
                    this.offsetToOrd = FieldArrayContext.parseOffsetArray(this.scratch);
                } else {
                    this.offsetToOrd = null;
                }
                return true;
            }
            this.offsetToOrd = null;
            return false;
        }

        public int count() {
            if (this.hasValue) {
                if (this.offsetToOrd != null) {
                    return this.offsetToOrd.length + 1;
                }
                return this.valueDocValues.docValueCount();
            }
            if (this.hasOffset) {
                return 2;
            }
            return 0;
        }

        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue && !this.hasOffset) {
                return;
            }
            if (this.offsetToOrd != null && this.hasValue) {
                long[] ords = new long[this.valueDocValues.docValueCount()];
                for (int i = 0; i < this.valueDocValues.docValueCount(); ++i) {
                    ords[i] = this.valueDocValues.nextOrd();
                }
                for (int offset : this.offsetToOrd) {
                    if (offset == -1) {
                        b.nullValue();
                        continue;
                    }
                    long ord = ords[offset];
                    BytesRef c = this.valueDocValues.lookupOrd(ord);
                    c = this.converter.apply(c);
                    b.utf8Value(c.bytes, c.offset, c.length);
                }
            } else if (this.offsetToOrd != null) {
                for (int offset : this.offsetToOrd) {
                    assert (offset == -1);
                    b.nullValue();
                }
            } else {
                for (int i = 0; i < this.valueDocValues.docValueCount(); ++i) {
                    BytesRef c = this.valueDocValues.lookupOrd(this.valueDocValues.nextOrd());
                    c = this.converter.apply(c);
                    b.utf8Value(c.bytes, c.offset, c.length);
                }
            }
        }
    }
}

