/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es818;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene95.OffHeapByteVectorValues;
import org.apache.lucene.codecs.lucene95.OffHeapFloatVectorValues;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.ReadAdvice;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.elasticsearch.index.codec.vectors.es818.DirectIOIndexInputSupplier;
import org.elasticsearch.index.codec.vectors.es818.ES818BinaryQuantizedVectorsFormat;
import org.elasticsearch.index.codec.vectors.reflect.OffHeapStats;

@SuppressForbidden(reason="Copied from lucene")
public class DirectIOLucene99FlatVectorsReader
extends FlatVectorsReader
implements OffHeapStats {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(DirectIOLucene99FlatVectorsReader.class);
    private final IntObjectHashMap<FieldEntry> fields = new IntObjectHashMap();
    private final IndexInput vectorData;
    private final FieldInfos fieldInfos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DirectIOLucene99FlatVectorsReader(SegmentReadState state, FlatVectorsScorer scorer) throws IOException {
        super(scorer);
        int versionMeta = this.readMetadata(state);
        this.fieldInfos = state.fieldInfos;
        boolean success = false;
        try {
            this.vectorData = DirectIOLucene99FlatVectorsReader.openDataInput(state, versionMeta, "vec", "Lucene99FlatVectorsFormatData", state.context.withReadAdvice(ReadAdvice.RANDOM));
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readMetadata(SegmentReadState state) throws IOException {
        int versionMeta;
        block11: {
            String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"vemf");
            versionMeta = -1;
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader((DataInput)meta, (String)"Lucene99FlatVectorsFormatMeta", (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    this.readFields(meta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)meta, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)meta, (Throwable)priorE);
            }
        }
        return versionMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName, IOContext context) throws IOException {
        IndexInput indexInput;
        block7: {
            IndexInput indexInput2;
            String fileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)fileExtension);
            assert (ES818BinaryQuantizedVectorsFormat.USE_DIRECT_IO);
            Directory directory = FilterDirectory.unwrap((Directory)state.directory);
            if (directory instanceof DirectIOIndexInputSupplier) {
                DirectIOIndexInputSupplier did = (DirectIOIndexInputSupplier)directory;
                indexInput2 = did.openInputDirect(fileName, context);
            } else {
                indexInput2 = state.directory.openInput(fileName, context);
            }
            IndexInput in = indexInput2;
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader((DataInput)in, (String)codecName, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, (DataInput)in);
                }
                CodecUtil.retrieveChecksum((IndexInput)in);
                success = true;
                indexInput = in;
                if (success) break block7;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
        return indexInput;
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            FieldEntry fieldEntry = FieldEntry.create((IndexInput)meta, info);
            this.fields.put(info.number, (Object)fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.fields.ramBytesUsed();
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.vectorData);
    }

    public FlatVectorsReader getMergeInstance() {
        try {
            this.vectorData.updateReadAdvice(ReadAdvice.SEQUENTIAL);
            return this;
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    private FieldEntry getFieldEntry(String field, VectorEncoding expectedEncoding) {
        FieldEntry fieldEntry;
        FieldInfo info = this.fieldInfos.fieldInfo(field);
        if (info == null || (fieldEntry = (FieldEntry)this.fields.get(info.number)) == null) {
            throw new IllegalArgumentException("field=\"" + field + "\" not found");
        }
        if (fieldEntry.vectorEncoding != expectedEncoding) {
            throw new IllegalArgumentException("field=\"" + field + "\" is encoded as: " + String.valueOf(fieldEntry.vectorEncoding) + " expected: " + String.valueOf(expectedEncoding));
        }
        return fieldEntry;
    }

    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field, VectorEncoding.FLOAT32);
        return OffHeapFloatVectorValues.load((VectorSimilarityFunction)fieldEntry.similarityFunction, (FlatVectorsScorer)this.vectorScorer, (OrdToDocDISIReaderConfiguration)fieldEntry.ordToDoc, (VectorEncoding)fieldEntry.vectorEncoding, (int)fieldEntry.dimension, (long)fieldEntry.vectorDataOffset, (long)fieldEntry.vectorDataLength, (IndexInput)this.vectorData);
    }

    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field, VectorEncoding.BYTE);
        return OffHeapByteVectorValues.load((VectorSimilarityFunction)fieldEntry.similarityFunction, (FlatVectorsScorer)this.vectorScorer, (OrdToDocDISIReaderConfiguration)fieldEntry.ordToDoc, (VectorEncoding)fieldEntry.vectorEncoding, (int)fieldEntry.dimension, (long)fieldEntry.vectorDataOffset, (long)fieldEntry.vectorDataLength, (IndexInput)this.vectorData);
    }

    public RandomVectorScorer getRandomVectorScorer(String field, float[] target) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field, VectorEncoding.FLOAT32);
        return this.vectorScorer.getRandomVectorScorer(fieldEntry.similarityFunction, (KnnVectorValues)OffHeapFloatVectorValues.load((VectorSimilarityFunction)fieldEntry.similarityFunction, (FlatVectorsScorer)this.vectorScorer, (OrdToDocDISIReaderConfiguration)fieldEntry.ordToDoc, (VectorEncoding)fieldEntry.vectorEncoding, (int)fieldEntry.dimension, (long)fieldEntry.vectorDataOffset, (long)fieldEntry.vectorDataLength, (IndexInput)this.vectorData), target);
    }

    public RandomVectorScorer getRandomVectorScorer(String field, byte[] target) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field, VectorEncoding.BYTE);
        return this.vectorScorer.getRandomVectorScorer(fieldEntry.similarityFunction, (KnnVectorValues)OffHeapByteVectorValues.load((VectorSimilarityFunction)fieldEntry.similarityFunction, (FlatVectorsScorer)this.vectorScorer, (OrdToDocDISIReaderConfiguration)fieldEntry.ordToDoc, (VectorEncoding)fieldEntry.vectorEncoding, (int)fieldEntry.dimension, (long)fieldEntry.vectorDataOffset, (long)fieldEntry.vectorDataLength, (IndexInput)this.vectorData), target);
    }

    public void finishMerge() throws IOException {
        this.vectorData.updateReadAdvice(ReadAdvice.RANDOM);
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.vectorData});
    }

    @Override
    public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
        return Map.of();
    }

    private record FieldEntry(VectorSimilarityFunction similarityFunction, VectorEncoding vectorEncoding, long vectorDataOffset, long vectorDataLength, int dimension, int size, OrdToDocDISIReaderConfiguration ordToDoc, FieldInfo info) {
        FieldEntry {
            if (similarityFunction != info.getVectorSimilarityFunction()) {
                throw new IllegalStateException("Inconsistent vector similarity function for field=\"" + info.name + "\"; " + String.valueOf(similarityFunction) + " != " + String.valueOf(info.getVectorSimilarityFunction()));
            }
            int infoVectorDimension = info.getVectorDimension();
            if (infoVectorDimension != dimension) {
                throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + infoVectorDimension + " != " + dimension);
            }
            int byteSize = switch (info.getVectorEncoding()) {
                default -> throw new MatchException(null, null);
                case VectorEncoding.BYTE -> 1;
                case VectorEncoding.FLOAT32 -> 4;
            };
            long vectorBytes = Math.multiplyExact((long)infoVectorDimension, byteSize);
            long numBytes = Math.multiplyExact(vectorBytes, size);
            if (numBytes != vectorDataLength) {
                throw new IllegalStateException("Vector data length " + vectorDataLength + " not matching size=" + size + " * dim=" + dimension + " * byteSize=" + byteSize + " = " + numBytes);
            }
        }

        static FieldEntry create(IndexInput input, FieldInfo info) throws IOException {
            VectorEncoding vectorEncoding = Lucene99HnswVectorsReader.readVectorEncoding((DataInput)input);
            VectorSimilarityFunction similarityFunction = Lucene99HnswVectorsReader.readSimilarityFunction((DataInput)input);
            long vectorDataOffset = input.readVLong();
            long vectorDataLength = input.readVLong();
            int dimension = input.readVInt();
            int size = input.readInt();
            OrdToDocDISIReaderConfiguration ordToDoc = OrdToDocDISIReaderConfiguration.fromStoredMeta((IndexInput)input, (int)size);
            return new FieldEntry(similarityFunction, vectorEncoding, vectorDataOffset, vectorDataLength, dimension, size, ordToDoc, info);
        }
    }
}

