/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.cluster;

import org.apache.lucene.util.LongHeap;
import org.apache.lucene.util.NumericUtils;

class NeighborQueue {
    private final LongHeap heap;
    private final Order order;

    NeighborQueue(int initialSize, boolean maxHeap) {
        this.heap = new LongHeap(initialSize);
        this.order = maxHeap ? Order.MAX_HEAP : Order.MIN_HEAP;
    }

    public int size() {
        return this.heap.size();
    }

    public void add(int newNode, float newScore) {
        this.heap.push(this.encode(newNode, newScore));
    }

    public boolean insertWithOverflow(int newNode, float newScore) {
        return this.heap.insertWithOverflow(this.encode(newNode, newScore));
    }

    private long encode(int node, float score) {
        return this.order.apply((long)NumericUtils.floatToSortableInt((float)score) << 32 | 0xFFFFFFFFL & (long)(~node));
    }

    int topNode() {
        return this.decodeNodeId(this.heap.top());
    }

    float topScore() {
        return this.decodeScore(this.heap.top());
    }

    private float decodeScore(long heapValue) {
        return NumericUtils.sortableIntToFloat((int)((int)(this.order.apply(heapValue) >> 32)));
    }

    private int decodeNodeId(long heapValue) {
        return (int)(this.order.apply(heapValue) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public int pop() {
        return this.decodeNodeId(this.heap.pop());
    }

    public void consumeNodes(int[] dest) {
        if (dest.length < this.size()) {
            throw new IllegalArgumentException("Destination array is too small. Expected at least " + this.size() + " elements.");
        }
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = this.decodeNodeId(this.heap.get(i + 1));
        }
    }

    public int consumeNodesAndScoresMin(int[] dest, float[] scores) {
        if (dest.length < this.size() || scores.length < this.size()) {
            throw new IllegalArgumentException("Destination array is too small. Expected at least " + this.size() + " elements.");
        }
        float bestScore = Float.POSITIVE_INFINITY;
        int bestIdx = 0;
        for (int i = 0; i < this.size(); ++i) {
            long heapValue = this.heap.get(i + 1);
            scores[i] = this.decodeScore(heapValue);
            dest[i] = this.decodeNodeId(heapValue);
            if (!(scores[i] < bestScore)) continue;
            bestScore = scores[i];
            bestIdx = i;
        }
        return bestIdx;
    }

    public void clear() {
        this.heap.clear();
    }

    public String toString() {
        return "Neighbors[" + this.heap.size() + "]";
    }

    private static enum Order {
        MIN_HEAP{

            @Override
            long apply(long v) {
                return v;
            }
        }
        ,
        MAX_HEAP{

            @Override
            long apply(long v) {
                return -1L - v;
            }
        };


        abstract long apply(long var1);
    }
}

